/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.fingerprint;

import com.digitalpersona.onetouch.DPFPGlobal;
import com.digitalpersona.onetouch.capture.DPFPCapture;
import com.digitalpersona.onetouch.capture.DPFPCaptureFactory;
import com.digitalpersona.onetouch.capture.event.DPFPDataAdapter;
import com.digitalpersona.onetouch.capture.event.DPFPDataEvent;
import com.digitalpersona.onetouch.capture.event.DPFPDataListener;
import java.util.Stack;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.signals.Signal;
import sun.awt.AppContext;

public class FingerprintDespatch
extends DPFPDataAdapter {
    private Stack<Signal> despatchList;
    protected static FingerprintDespatch instance;
    private static ThreadGroup threadGroup;

    public static final FingerprintDespatch getInstance() {
        if (instance == null) {
            DPFPCaptureFactory factory = null;
            try {
                factory = DPFPGlobal.getReadersFactory().getReaders().isEmpty() ? null : DPFPGlobal.getCaptureFactory();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Drivers not installed, cannot create FingerprintDespatch for a real fingerprint reader.", (Throwable)ex);
            }
            instance = new FingerprintDespatch(factory);
            threadGroup = AppContext.getAppContext().getThreadGroup();
        }
        return instance;
    }

    public FingerprintDespatch(DPFPCaptureFactory factory) {
        if (factory != null) {
            try {
                if (!DPFPGlobal.getReadersFactory().getReaders().isEmpty()) {
                    DPFPCapture capture = factory.createCapture();
                    if (capture != null) {
                        capture.addDataListener((DPFPDataListener)this);
                        capture.startCapture();
                    } else {
                        OrderMate.LOG.warn("Could not find a DPFPCapture, cannot listen to fingerprints.");
                    }
                } else {
                    OrderMate.LOG.info("No fingerprint readers are attached, capture will not be started.");
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.info("Cannot detect capture devices, install fingerprint scanner drivers.", (Throwable)ex);
            }
        }
        this.despatchList = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSignalToUse(Signal signal) {
        Stack<Signal> stack = this.despatchList;
        synchronized (stack) {
            if (this.despatchList.contains(signal)) {
                this.despatchList.remove(signal);
            }
            this.despatchList.push(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissSignal(Signal toDismiss) {
        Stack<Signal> stack = this.despatchList;
        synchronized (stack) {
            this.despatchList.remove(toDismiss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataAcquired(DPFPDataEvent event) {
        OrderMate.LOG.info("Acquired fingerprint, despatching.");
        Signal toUse = null;
        Stack<Signal> stack = this.despatchList;
        synchronized (stack) {
            if (!this.despatchList.isEmpty()) {
                toUse = this.despatchList.peek();
            }
        }
        if (toUse != null) {
            ExperimentalFeature offThread = ExperimentalFeature.find((String)"Fingerprint off-thread");
            if (offThread != null && offThread.getBooleanValue(Boolean.FALSE).booleanValue()) {
                OrderMate.LOG.warn("Emitting FingerPrint off thread.");
                final Signal finalToUse = toUse;
                final DPFPDataEvent finalEvent = event;
                new Thread(threadGroup, new Runnable(){

                    @Override
                    public void run() {
                        finalToUse.emit((Object)finalEvent.getSample());
                    }
                }).start();
            } else {
                toUse.emit((Object)event.getSample());
            }
        } else {
            OrderMate.LOG.warn("Had a fingerprint scanned, but no one cares.");
        }
    }

    protected static void setInstance(FingerprintDespatch despatch) {
        instance = despatch;
    }
}

