/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.fingerprint;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.GuiHandler;
import com.digitalpersona.onetouch.DPFPDataPurpose;
import com.digitalpersona.onetouch.DPFPFeatureSet;
import com.digitalpersona.onetouch.DPFPGlobal;
import com.digitalpersona.onetouch.DPFPSample;
import com.digitalpersona.onetouch.processing.DPFPImageQualityException;
import com.digitalpersona.onetouch.verification.DPFPVerification;
import com.digitalpersona.onetouch.verification.DPFPVerificationResult;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.users.User;
import ordermate.database.users.UserFingerprint;
import ordermate.services.users.UserFingerPrintService;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.fingerprint.ScanFinger;

public class VerifyFingerprint {
    protected static Class<? extends VerifyFingerprint> prototype = null;
    protected final GuiHandler gui;
    private UserFingerPrintService fingerPrint = new UserFingerPrintService();
    private final Signal gotScan = Signals.createSignal(DPFPSample.class, (String)"sample");
    private final Signal gotCancel = Signals.createSignal();
    protected Signal gotVerified;
    public User theUser;

    public static VerifyFingerprint makeVerifier(GuiHandler handler) {
        if (prototype != null) {
            try {
                return prototype.getConstructor(GuiHandler.class).newInstance(handler);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new VerifyFingerprint(handler);
    }

    public VerifyFingerprint(GuiHandler handler) {
        this.gui = handler;
        this.gotScan.connect((Object)this, "gotPrintScanned");
        this.gotCancel.connect((Object)this, "gotCancel");
    }

    public void startVerifyFingerprint(Signal verifiedSignal, User user, DPFPSample sample) {
        if (!Terminal.getLocalHost().isFingerprintScanner()) {
            OrderMate.LOG.info("Acquired fingerprint but no scanner should be attached.");
            this.gui.displayOkDialog("No Fingerprint Scanner", "<html>No fingerprint scanner is attached to this terminal.<br><br>Please clock on at a terminal with a fingerprint scanner.</html?");
            verifiedSignal.emit((Object)Boolean.FALSE);
            return;
        }
        this.gotVerified = verifiedSignal;
        if (user != null) {
            this.theUser = user;
            if (sample == null) {
                ScanFinger.getInstance().scanFinger(this.gotScan, this.gotCancel, this.gui, "This will verify your fingerprint");
            } else {
                this.gotPrintScanned(sample);
            }
        }
    }

    public boolean isMatch(DPFPSample sample, User user, boolean verbose) {
        this.theUser = user;
        DPFPFeatureSet featureSet = this.createFeatureSet(sample, verbose);
        if (featureSet != null) {
            if (this.verifyFingerprint(featureSet)) {
                return true;
            }
            if (verbose) {
                this.gui.displayOkDialog("<html>Finger print scanned does not match " + user.getName() + ".<br><br>Please log yourself in before attempting to clock in.</html>", "Fingerprints Rejected");
            }
        }
        return false;
    }

    public User matchUser(DPFPSample sample, List<User> users, boolean verbose) {
        DPFPFeatureSet featureSet = this.createFeatureSet(sample, verbose);
        Iterator<User> iterator = users.iterator();
        while (iterator.hasNext()) {
            User user;
            this.theUser = user = iterator.next();
            if (!this.verifyFingerprint(featureSet)) continue;
            return user;
        }
        return null;
    }

    private DPFPFeatureSet createFeatureSet(DPFPSample sample, boolean verbose) {
        if (sample == null) {
            return null;
        }
        try {
            return DPFPGlobal.getFeatureExtractionFactory().createFeatureExtraction().createFeatureSet(sample, DPFPDataPurpose.DATA_PURPOSE_VERIFICATION);
        }
        catch (DPFPImageQualityException ex) {
            if (verbose) {
                this.gui.displayOkDialog("Bad Sample", "<html>The scanned print was not suitable for verification.<br><br>Ensure your hands are clean and free from bandaids, oil or dust and try again.<html>");
            }
            OrderMate.LOG.warn("Bad Fingerprint sample", (Throwable)ex);
            return null;
        }
    }

    protected void gotPrintScanned(DPFPSample sample) {
        DPFPFeatureSet featureSet = this.createFeatureSet(sample, true);
        if (featureSet == null) {
            this.gotVerified.emit((Object)Boolean.FALSE);
            return;
        }
        this.gotVerified.emit((Object)this.verifyFingerprint(featureSet));
        this.gotVerified = null;
        this.theUser = null;
    }

    void gotCancel() {
        this.gotPrintScanned(null);
    }

    private boolean verifyFingerprint(DPFPFeatureSet featureSet) {
        String securityString;
        if (featureSet == null || this.theUser == null) {
            return false;
        }
        DPFPVerification verification = DPFPGlobal.getVerificationFactory().createVerification();
        int security = 2147;
        if (Config.isConfigSetup() && (securityString = Config.getStringValue((String)"FINGERPRINT_SECURITY")) != null) {
            if ("low".equals(securityString = securityString.toLowerCase())) {
                security = 214748;
            } else if ("med".equals(securityString)) {
                security = 21474;
            } else if ("one".equals(securityString)) {
                security = Integer.MAX_VALUE;
            }
            OrderMate.LOG.debug("Config setting fingerprint security level to " + security);
        }
        verification.setFARRequested(security);
        List prints = UserFingerprint.getFingerprintsForUser((User)this.theUser);
        for (UserFingerprint nextPrint : prints) {
            DPFPVerificationResult result = verification.verify(featureSet, this.fingerPrint.getPrintTemplate(nextPrint));
            if (!result.isVerified()) continue;
            return true;
        }
        return false;
    }
}

