/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.mandatory;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Color;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class AbstractMandatoryFieldsPanel<P extends PersistentObject>
extends JPanel {
    public final Signal newInput = Signals.createSignal();
    private Boolean panelValidity;
    private List<PropertiedObject.Property> mandatoryFields;
    boolean fieldsRequired;
    public final Signal<Boolean, AbstractMandatoryFieldsPanel, ?, ?, ?> panelValiditySignal = Signals.createSignal(Boolean.class, (String)"isValid", AbstractMandatoryFieldsPanel.class, (String)"this");
    private String panelTitle;
    private final Border fieldsNOTOkBorder = new LineBorder(Color.RED, 3);

    public AbstractMandatoryFieldsPanel() {
        this.panelValidity = null;
    }

    public AbstractMandatoryFieldsPanel(LayoutManager layout) {
        super(layout);
    }

    protected abstract void doRequiredFieldsVisualFeedback();

    public void setFieldsRequired(List<PropertiedObject.Property> newMandatoryFields) {
        this.mandatoryFields = newMandatoryFields;
        this.fieldsRequired = this.mandatoryFields.size() > 0;
        this.doRequiredFieldsVisualFeedback();
    }

    public List<PropertiedObject.Property> getFieldsRequired() {
        return this.mandatoryFields;
    }

    public boolean isFieldsRequired() {
        return this.fieldsRequired;
    }

    protected void paintComponentAsRequired(JComponent component, boolean requirementsMet) {
        if (requirementsMet && component.getClientProperty("ordermate.showinginvalidborder") != null) {
            component.setBorder((Border)component.getClientProperty("ordermate.validborder"));
            component.putClientProperty("ordermate.showinginvalidborder", null);
        } else if (!requirementsMet && component.getClientProperty("ordermate.showinginvalidborder") == null) {
            component.putClientProperty("ordermate.validborder", component.getBorder());
            component.putClientProperty("ordermate.showinginvalidborder", Boolean.TRUE);
            component.setBorder(this.fieldsNOTOkBorder);
        }
        this.emitValidityChangeSignal();
    }

    protected boolean isMarkedAsInvalid(JComponent comp) {
        return comp.getBorder() == this.fieldsNOTOkBorder;
    }

    public abstract boolean hasPanelMetRequirements();

    protected void emitValidityChangeSignal() {
        Boolean newValidity;
        this.panelValidity = newValidity = Boolean.valueOf(this.hasPanelMetRequirements());
        this.panelValiditySignal.emit((Object)this.panelValidity, (Object)this);
    }

    public void setPanelTitle(String title) {
        this.panelTitle = title;
    }

    public String getPanelTitle() {
        return this.panelTitle;
    }

    public String getPanelTitleFormatted(String HTMLColor) {
        String formattedPanelTitle = "";
        formattedPanelTitle = HTMLColor == null || HTMLColor.trim().equals("") ? "<HTML>" + this.getPanelTitle() + "</HTML>" : "<HTML><FONT COLOR =" + HTMLColor + ">" + this.getPanelTitle() + "</FONT></HTML>";
        return formattedPanelTitle;
    }

    public boolean isPanelValid() {
        return this.panelValidity == null ? true : this.panelValidity;
    }

    public abstract void loadObject(P var1);

    public abstract P saveObject(P var1);

    public abstract void reset();

    public abstract void selectFirstInvalid();
}

