/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.mandatory;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import ordermate.database.RequiredFields;
import waitermate.gui.mandatory.AbstractMandatoryFieldsPanel;

public abstract class ButtonMandatoryFieldsPanel<P extends PersistentObject>
extends AbstractMandatoryFieldsPanel<P> {
    protected ButtonGroup buttons;
    private Map<PropertiedObject.Property, AbstractButton> propertyButtonMap = new LinkedHashMap<PropertiedObject.Property, AbstractButton>();

    public ButtonMandatoryFieldsPanel() {
        this(new FlowLayout());
    }

    public ButtonMandatoryFieldsPanel(LayoutManager manager) {
        super(manager);
        this.buttons = new ButtonGroup();
    }

    protected final void registerButton(PropertiedObject.Property property, AbstractButton button) {
        this.propertyButtonMap.put(property, button);
    }

    protected boolean isRequirementMet(AbstractButton component) {
        return component.getText() != null && !component.getText().equalsIgnoreCase("");
    }

    @Override
    public void loadObject(P object) {
        if (object != null) {
            for (PropertiedObject.Property property : this.propertyButtonMap.keySet()) {
                Object data = object.getPropertyValue(property);
                if (property.getType().isAssignableFrom(String.class)) {
                    if (data != null) {
                        this.propertyButtonMap.get(property).setText(String.valueOf(data));
                        continue;
                    }
                    this.propertyButtonMap.get(property).setText(null);
                    continue;
                }
                if (!property.getType().isAssignableFrom(Boolean.TYPE)) continue;
                this.propertyButtonMap.get(property).setSelected((Boolean)data);
            }
            this.doRequiredFieldsVisualFeedback();
            this.newInput.emit();
        }
    }

    @Override
    public P saveObject(P object) {
        if (object != null) {
            for (PropertiedObject.Property property : this.propertyButtonMap.keySet()) {
                Object data = null;
                if (property.getType().isAssignableFrom(String.class)) {
                    data = this.propertyButtonMap.get(property).getText();
                } else if (property.getType().isAssignableFrom(Boolean.TYPE)) {
                    data = this.propertyButtonMap.get(property).isSelected();
                } else {
                    throw new IllegalArgumentException("Cannot determine button return type for Mandatory field:" + property);
                }
                if (data == null) continue;
                PropertiedObject.PropsHelper.setPropertyValue(object, (PropertiedObject.Property)property, (Object)data);
            }
        }
        return object;
    }

    public void addButtonProperty(PropertiedObject.Property property, AbstractButton button) {
        this.propertyButtonMap.put(property, button);
    }

    public AbstractButton getButtonForProperty(PropertiedObject.Property property) {
        return this.propertyButtonMap.get(property);
    }

    public PropertiedObject.Property getPropertyForButton(AbstractButton button) {
        for (PropertiedObject.Property prop : this.propertyButtonMap.keySet()) {
            if (this.propertyButtonMap.get(prop) != button) continue;
            return prop;
        }
        return null;
    }

    public Set<PropertiedObject.Property> getProperties() {
        return this.propertyButtonMap.keySet();
    }

    @Override
    protected void doRequiredFieldsVisualFeedback() {
        for (PropertiedObject.Property property : this.getProperties()) {
            AbstractButton button = this.getButtonForProperty(property);
            if (this.getFieldsRequired().contains(property)) {
                this.paintComponentAsRequired(button, this.getRequiredObject().getMeetsRequirement(property));
                continue;
            }
            this.paintComponentAsRequired(button, true);
        }
    }

    protected abstract RequiredFields getRequiredObject();

    protected abstract void setSelectedButton(AbstractButton var1);

    @Override
    public void selectFirstInvalid() {
        AbstractButton toSelect = null;
        if (this.isPanelValid()) {
            for (AbstractButton button : this.propertyButtonMap.values()) {
                if (!button.isVisible() || button.getParent() == null) continue;
                button.requestFocusInWindow();
                toSelect = button;
                break;
            }
        } else {
            for (AbstractButton button : this.propertyButtonMap.values()) {
                if (!button.isVisible() || button.getParent() == null || !this.isMarkedAsInvalid(button)) continue;
                toSelect = button;
                break;
            }
        }
        if (toSelect != null) {
            toSelect.setSelected(true);
            this.setSelectedButton(toSelect);
        }
    }
}

