/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.overview;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.overview.OverviewPage;

class WaiterMateOverviewPanel
extends JPanel
implements MouseListener {
    final Signal<OverviewPage, ?, ?, ?, ?> changePage = Signals.createSignal(OverviewPage.class, (String)"thePage");
    private JPanel pageHolder;
    private JPanel navBar;
    private JLabel statusLabel;

    WaiterMateOverviewPanel() {
        super(new BorderLayout());
        Color funkyColor = new Color(0.4f, 0.5f, 0.6f, 0.7f);
        this.setOpaque(false);
        this.setBackground(funkyColor);
        this.addMouseListener(this);
        this.setupComponents();
    }

    void setPages(List<OverviewPage> possiblePages) {
        this.navBar.removeAll();
        for (final OverviewPage nextPage : possiblePages) {
            JButton button = new JButton(nextPage.getLabel(), IconLoader.get((String)nextPage.getIcon()));
            OrderMateTheme.setupTouchScreenButton((AbstractButton)button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    WaiterMateOverviewPanel.this.changePage.emit((Object)nextPage);
                }
            });
            StandardSecurityDecorator dec = new StandardSecurityDecorator((JComponent)button, nextPage.getPermission());
            this.navBar.add((Component)dec);
        }
    }

    private void setupComponents() {
        this.statusLabel = new JLabel("");
        this.statusLabel.setName("WMReportStatus");
        this.statusLabel.setHorizontalAlignment(0);
        this.add((Component)this.statusLabel, "North");
        this.navBar = new JPanel(new FlowLayout());
        this.navBar.setOpaque(false);
        this.add((Component)this.navBar, "South");
        this.pageHolder = new JPanel(new BorderLayout());
        this.pageHolder.setOpaque(false);
        this.add((Component)this.pageHolder, "Center");
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void setPage(OverviewPage currentPage) {
        this.pageHolder.removeAll();
        if (currentPage != null) {
            this.pageHolder.add(currentPage.getComponent());
            this.statusLabel.setText(currentPage.getLabel());
            this.statusLabel.setIcon(IconLoader.get((String)currentPage.getIcon()));
        } else {
            this.statusLabel.setText("No report permitted");
            this.statusLabel.setIcon(IconLoader.get((String)"/waitermate/images/crossed_circle2.png"));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.consume();
    }
}

