/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.overview.flashreport;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.Shift;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.reports.WaitermateReport;

public class TodayStatusReportCompiler
implements WaitermateReport {
    private DecimalFormat priceFormat = new DecimalFormat("0.00");
    private List<StatusReportObject> currentResults;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performReport() {
        ObjectQuery query = this.getQuery();
        Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null);
        ArrayList<StatusReportObject> reports = new ArrayList<StatusReportObject>(results.length);
        for (int i = 0; i < results.length; ++i) {
            StatusReportObject newReport = new StatusReportObject();
            newReport.loc = (SalesLocation)PersistenceManager.getByID((long)((Long)results[i][0]), SalesLocation.class);
            newReport.shift = (Shift)PersistenceManager.getByID((long)((Long)results[i][1]), Shift.class);
            newReport.price = (Double)results[i][2];
            newReport.pax = ((BigDecimal)results[i][3]).intValue();
            reports.add(newReport);
        }
        TodayStatusReportCompiler todayStatusReportCompiler = this;
        synchronized (todayStatusReportCompiler) {
            this.currentResults = reports;
        }
    }

    @Override
    public synchronized List<String> getStringData() {
        if (this.currentResults == null) {
            return null;
        }
        ArrayList<String> reportList = new ArrayList<String>();
        this.processLocations(reportList);
        this.processAllLocations(reportList);
        return reportList;
    }

    private void processLocations(List<String> reportList) {
        int count = 0;
        StatusReportObject totalObject = new StatusReportObject();
        SalesLocation currentLocation = null;
        int size = this.currentResults.size();
        for (int i = 0; i < size; ++i) {
            StatusReportObject nextReport = this.currentResults.get(i);
            this.process(nextReport, reportList, !nextReport.loc.equals(currentLocation));
            totalObject.addReport(nextReport);
            if (nextReport.loc.equals(currentLocation)) {
                ++count;
            } else {
                if (count == 0) {
                    reportList.remove(reportList.size() - 1);
                }
                StringBuilder SB = new StringBuilder("Total");
                this.addResult(SB, totalObject);
                reportList.add(SB.toString());
                count = 0;
                totalObject.pax = 0;
                totalObject.price = 0.0;
            }
            currentLocation = nextReport.loc;
        }
    }

    private void process(StatusReportObject report, List<String> reportList, boolean addTitle) {
        StringBuilder SB = new StringBuilder();
        if (addTitle) {
            SB.append("**").append(report.loc.getLabel()).append(" Location**");
            reportList.add(SB.toString());
        }
        SB = new StringBuilder(report.shift.getName()).append(" Shift");
        this.addResult(SB, report);
        reportList.add(SB.toString());
    }

    private void processAllLocations(List<String> reportList) {
        StringBuilder SB;
        reportList.add("**All Locations**");
        StatusReportObject total = new StatusReportObject();
        LinkedHashMap<Shift, StatusReportObject> shiftTotalMap = new LinkedHashMap<Shift, StatusReportObject>();
        for (StatusReportObject nextReport : this.currentResults) {
            StatusReportObject summary;
            Shift shift = nextReport.shift;
            if (!shiftTotalMap.containsKey(shift)) {
                summary = new StatusReportObject();
                shiftTotalMap.put(shift, summary);
            }
            summary = (StatusReportObject)shiftTotalMap.get(shift);
            summary.addReport(nextReport);
            total.addReport(nextReport);
        }
        for (Shift nextShift : shiftTotalMap.keySet()) {
            SB = new StringBuilder(nextShift.getName()).append(" Shift");
            this.addResult(SB, (StatusReportObject)shiftTotalMap.get(nextShift));
            reportList.add(SB.toString());
        }
        SB = new StringBuilder("Total");
        this.addResult(SB, total);
        reportList.add(SB.toString());
    }

    private void addResult(StringBuilder SB, StatusReportObject report) {
        SB.append(": ").append(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        SB.append(this.priceFormat.format(report.price)).append(" / ");
        SB.append(report.pax).append("pax");
    }

    private ObjectQuery getQuery() {
        TradingDay currentTradingDay = TradingDay.getCurrentTradingDay();
        ObjectQuery query = Query.selectFunc((String)"SI.fk_config_sales_location as loc_id").select(Shift.Properties.ID, "fk_finance_shift").sum(Account.Properties.SAVED_TOTAL, "total").sum(Account.Properties.NUM_PATRONS, "num_patrons").linkUsing(Account.Properties.SHIFT).equals(Shift.Properties.TRADING_DAY, (Object)currentTradingDay).orderBy("SI.fk_config_sales_location", false).orderBy(Account.Properties.SHIFT).groupBy("SI.fk_config_sales_location").groupBy(Account.Properties.SHIFT);
        query.joinFunction("JOIN (SELECT min(sales_item.id), sales_item.fk_sales_account, sales_item.fk_config_terminal, sales_item_quantity.fk_config_sales_location from sales_item JOIN sales_item_quantity ON sales_item.id=sales_item_quantity.fk_sales_item WHERE sales_item_quantity.fk_finance_trading_day = " + currentTradingDay.getID() + " group by sales_item.fk_sales_account) as SI on sales_account.id = SI.fk_sales_account", SalesLineItem.class);
        return query;
    }

    static class StatusReportObject {
        SalesLocation loc;
        Shift shift;
        double price;
        int pax;

        StatusReportObject() {
        }

        void addReport(StatusReportObject nextReport) {
            this.price += nextReport.price;
            this.pax += nextReport.pax;
        }
    }
}

