/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.overview.userreport;

import au.com.ordermate.oquery.search.QueryPart;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.contest.Contest;
import ordermate.database.contest.ContestHelper;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.config.patrons.BasePPACompiler;
import ordermate.database.reports.config.patrons.BasePatronsCompiler;
import ordermate.database.reports.contest.ContestReportHelper;
import ordermate.database.reports.contest.ContestReportParams;
import ordermate.database.reports.contest.compiler.ContestAggregateReportCompiler;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.reports.dynamicjasper.ArbitraryPeriodReportAdapter;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import waitermate.LoginManager;
import waitermate.gui.overview.OverviewPage;
import waitermate.gui.overview.OverviewState;
import waitermate.gui.overview.WMTwinReportPanel;

public class WaitermateUserReportPage
implements OverviewPage {
    private static final String ICON = "/waitermate/images/user.png";
    private static final String LABEL = "User Reports";
    private static final String TOTAL = "total_ex";
    private static final String TOTAL_DISCOUNTS = "total_discounts";
    private static final String TOTAL_SURCHARGES = "total_surcharges";
    private static final String PATRONS = "patrons";
    private static final String USER = "user";
    private WMTwinReportPanel panel = new WMTwinReportPanel("User Average", "Contest");
    private BasePPACompiler ppaCompiler;
    private BasePatronsCompiler patronsCompiler;
    private ContestAggregateReportCompiler contestCompiler;
    static final String MSG_USER_REPORT_NO_DAY_PARTS = "No day parts have been setup to view this report, please ask your manager";

    @Override
    public void overviewChanged(OverviewState state) {
        if (OverviewState.Closed.equals((Object)state)) {
            this.panel.clear();
        } else {
            boolean half = OverviewState.Half.equals((Object)state);
            this.panel.showHalf(half);
            this.updateData(half);
        }
    }

    private void updateData(boolean ppaOnly) {
        List<String> ppaReport = this.doPPA();
        ArrayList<String> contestReport = new ArrayList();
        if (!ppaOnly) {
            contestReport = this.doContest();
        }
        this.panel.dataUpdated(ppaReport, contestReport);
    }

    List<String> doPPA() {
        if (!DayPart.isDayPartsDefined()) {
            OrderMate.LOG.warn("User Average Report will not be displayed since day parts are not defined!");
            return Collections.singletonList(MSG_USER_REPORT_NO_DAY_PARTS);
        }
        Date date = new Date();
        this.ppaCompiler.setDate(date);
        this.ppaCompiler.compile();
        this.patronsCompiler.setDate(date);
        this.patronsCompiler.compile();
        ArrayList<String> first = new ArrayList<String>();
        Set rowIdentifiers = this.ppaCompiler.getRowIdentifiers();
        String[][] table = new String[rowIdentifiers.size() + 1][];
        table[0] = new String[]{"User", "Total", "Patrons", "Average"};
        int i = 0;
        NumberFormat priceFormat = DecimalFormat.getCurrencyInstance();
        for (Object row : rowIdentifiers) {
            Double average;
            Number total_disc = (Number)this.ppaCompiler.getValue(row, TOTAL_DISCOUNTS);
            Number total_sur = (Number)this.ppaCompiler.getValue(row, TOTAL_SURCHARGES);
            if (total_disc.doubleValue() < 0.0) {
                total_disc = total_disc.doubleValue() * -1.0;
            }
            if (total_sur.doubleValue() < 0.0) {
                total_sur = total_sur.doubleValue() * -1.0;
            }
            Number total = (Number)this.ppaCompiler.getValue(row, TOTAL);
            Number patrons = (Number)this.patronsCompiler.getValue(row, PATRONS);
            if (patrons == null) {
                patrons = 0;
                average = Double.NaN;
            } else {
                total = total.doubleValue() + total_disc.doubleValue() - total_sur.doubleValue();
                average = total.doubleValue() / patrons.doubleValue();
            }
            table[i + 1] = new String[]{String.valueOf(this.ppaCompiler.getValue(row, USER)), priceFormat.format(total.doubleValue()), String.valueOf(patrons), priceFormat.format(average)};
            ++i;
        }
        first.add(HtmlUtils.table((String[][])table, (boolean)true, (boolean)false));
        return first;
    }

    private List<String> doContest() {
        Contest contest = ContestHelper.INSTANCE.getWaiterMateDisplayableContest();
        if (contest == null) {
            return Collections.singletonList("No contests have been setup please ask your manager");
        }
        this.contestCompiler.setContest(contest);
        this.contestCompiler.compileReport();
        return ContestReportHelper.INSTANCE.getReportDataPerUser(this.contestCompiler, LoginManager.getInstance().getUser());
    }

    @Override
    public void startPage() {
        if (this.ppaCompiler == null) {
            this.ppaCompiler = new BasePPACompiler();
            this.ppaCompiler.setPeriod(PeriodReportAdapter.DAILY);
            this.ppaCompiler.applyQueryPart(Arrays.asList(new CustomReportQueryPart(null, QueryPart.GROUP, this.ppaCompiler.getBaseReport(), "id", "config_user")));
            this.patronsCompiler = new BasePatronsCompiler();
            this.patronsCompiler.setPeriod(PeriodReportAdapter.DAILY);
            this.patronsCompiler.applyQueryPart(Arrays.asList(new CustomReportQueryPart(null, QueryPart.GROUP, this.patronsCompiler.getBaseReport(), "id", "config_user")));
        }
        if (this.contestCompiler == null) {
            Contest contest = ContestHelper.INSTANCE.getWaiterMateDisplayableContest();
            ContestReportParams contestReportParams = new ContestReportParams(contest);
            Date today = new Date();
            contestReportParams.setPeriod((PeriodReportAdapter)new ArbitraryPeriodReportAdapter(DateTimeUtils.getStartOfDay((Date)today), DateTimeUtils.getEndOfDay((Date)today)));
            this.contestCompiler = new ContestAggregateReportCompiler(contestReportParams);
        }
    }

    @Override
    public void stopPage() {
        this.ppaCompiler = null;
        this.contestCompiler = null;
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public String getIcon() {
        return ICON;
    }

    @Override
    public Permission getPermission() {
        return AllPermissions.ACCESS_USER_REPORTS;
    }
}

