/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.hardware.Terminal;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.AdminCategoryPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.SignalEmittingTimer;

public class Admin
extends AbstractScreen {
    private AdminCategoryPanel gui;
    private NavBar navPanel;
    public final Signal back = Signals.createSignal();
    public final Signal logout = Signals.createSignal();
    private SignalEmittingTimer backTimer;
    public static final int DEFAULT_BACK_TIMEOUT = 900;

    public void startAdmin() {
        if (this.gui == null) {
            this.setupGui();
        }
        this.gui.startTabs();
        this.gui.setSelectedIndex(0);
        this.display();
    }

    private void setupGui() {
        this.gui = new AdminCategoryPanel(this);
        this.gui.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Admin.this.resetBackTimer();
            }
        });
        this.gui.back.connect((Object)this, "display");
        this.gui.logout.connect(this.logout);
        this.navPanel = new NavBar();
        this.navPanel.addLeft((Component)this.navPanel.getBackButton());
        this.navPanel.setText(Internationalization.getLiteralFor((String)"SELECT_ADMINISTRATION_FUNCTION"));
        this.navPanel.back.connect((Object)this.back, "emit");
    }

    public void display() {
        super.display();
        this.resetBackTimer();
    }

    private void resetBackTimer() {
        int FIFTEEN_SEC = 15;
        int timeout = Terminal.getLocalHost().getBackToIdleTimeout();
        if (timeout <= 0) {
            timeout = 900;
        }
        if (this.backTimer != null) {
            this.backTimer.stop();
        }
        this.backTimer = new SignalEmittingTimer(timeout, 15, (AbstractScreen)this, this.back, Internationalization.getLiteralFor((String)"THE_SYSTEM_WILL_AUTOMATICALLY_LEAVE_THIS_SCREEN"), "Back");
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navPanel;
    }

    public void tearDown() {
        if (this.backTimer != null) {
            this.backTimer.stop();
            this.backTimer = null;
        }
        super.tearDown();
    }
}

