/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin;

import java.awt.Component;
import ordermate.database.Lockable;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalMode;
import ordermate.database.sales.Account;
import ordermate.database.tables.LogicalTable;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.selectaccount.SelectAccount;
import waitermate.gui.screens.selectaccount.online.OnlineAccountSelection;
import waitermate.gui.screens.selectaccount.phone.PhoneSelection;
import waitermate.gui.screens.selectaccount.table.TableAccountSelection;
import waitermate.gui.screens.selectaccount.takeaway.DriveThruSelection;
import waitermate.gui.screens.selectaccount.takeaway.TakeawaySelection;
import waitermate.gui.screens.selectaccount.takeaway.bartabs.BarTabSelection;
import waitermate.guikit.NavBar;

public class SelectUnlockAccount
extends SelectAccount {
    @Override
    protected void initScreens(boolean isUnallocateTables) {
        Terminal myTerminal = Terminal.getLocalHost();
        for (TerminalMode mode : myTerminal.getTerminalModes()) {
            PhoneSelection phone;
            if (mode.getMode().equals("Tables")) {
                this.tables = new TableAccountSelection(true, isUnallocateTables);
                this.tables.setDisplayLastTableAccessedText(false);
                this.tables.accountSelected.connect((Object)this, "gotAccount");
                this.tables.tableSelected.connect((Object)this, "gotTable");
                this.tables.setAllowInterfaceUnlocking(true);
                this.setupNavBar(this.tables.getNavBar());
                this.addGuiState(this.tables, mode.getLabel());
                continue;
            }
            if (mode.getMode().equals("Phone")) {
                phone = new PhoneSelection(false);
                this.addGuiState(phone, mode.getLabel());
                phone.accountSelected.connect((Object)this, "gotAccount");
                this.setupNavBar(phone.getNavBar());
                continue;
            }
            if (mode.getMode().equals("Phone with Delivery")) {
                phone = new PhoneSelection(true);
                this.addGuiState(phone, mode.getLabel());
                phone.accountSelected.connect((Object)this, "gotAccount");
                this.setupNavBar(phone.getNavBar());
                continue;
            }
            if (mode.getMode().equals("Takeaway")) {
                TakeawaySelection takeaway = new TakeawaySelection();
                this.addGuiState(takeaway, mode.getLabel());
                takeaway.accountSelected.connect((Object)this, "gotAccount");
                this.setupNavBar(takeaway.getNavBar());
                continue;
            }
            if (mode.getMode().equals("Drive Thru")) {
                DriveThruSelection drivethru = new DriveThruSelection();
                this.addGuiState(drivethru, mode.getLabel());
                drivethru.accountSelected.connect((Object)this, "gotAccount");
                this.setupNavBar(drivethru.getNavBar());
                continue;
            }
            if (mode.getMode().equals("Bar Tabs")) {
                BarTabSelection barTabs = new BarTabSelection(true);
                this.addGuiState(barTabs, mode.getLabel());
                barTabs.accountSelected.connect((Object)this, "gotAccount");
                this.setupNavBar(barTabs.getNavBar());
                continue;
            }
            if (!mode.getMode().equals("Online")) continue;
            OnlineAccountSelection onlineSelection = new OnlineAccountSelection();
            this.addGuiState(onlineSelection, mode.getLabel());
            onlineSelection.accountSelected.connect((Object)this, "gotAccount");
            this.setupNavBar(onlineSelection.getNavBar());
        }
    }

    @Override
    protected void setupNavBar(NavBar nav) {
        nav.hideAllButtons();
        nav.addLeft((Component)nav.getBackButton());
        nav.back.connect((Object)this.back, "emit");
        nav.setText(Internationalization.getLiteralFor((String)"SELECT_ACCOUNT_TO_UNLOCK"));
    }

    @Override
    public void gotAccount(Account theAccount) {
        if (WaitermateSaveAccount.getInstance().unlock((Lockable)theAccount)) {
            this.back.emit();
        }
    }

    @Override
    public void gotTable(LogicalTable theTable) {
        if (!theTable.isLocked() && theTable.hasAccount() && theTable.getAccount() != null) {
            this.gotAccount((Account)theTable.getAccount());
        } else if (WaitermateSaveAccount.getInstance().unlock((Lockable)theTable)) {
            if (theTable.hasAccount() && theTable.getAccount().isLocked()) {
                theTable.getAccount().unlock();
            }
            this.back.emit();
        }
    }
}

