/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.adjusttime;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.UpdateTimeTask;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.adjusttime.AdjustTimePanel;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.task.RestartWaitermateTask;

public class AdjustTime {
    private AdjustTime() {
    }

    public static void adjustTime() {
        if (!Dialogs.displayChoiceDialog((String)("<html><b>" + Internationalization.getLiteralFor((String)"PLEASE_NOTE_THAT_IMPROPERLY_ADJUSTING_THE_TIME_CAN_RESULT_IN_ERRORS_IN_REPORTS_AND_TAKINGS") + "</b><br><br>" + Internationalization.getLiteralFor((String)"ONCE_THE_TIME_HAS_BEEN_SET_ON_THE_SERVER_THIS_TERMINAL_WILL_RESTART") + "<br>" + Internationalization.getLiteralFor((String)"OTHER_WAITERMATE_TERMINALS_MUST_BE_RESTARTED_TO_SYNCHRONIZE_WITH_THE_NEW_TIME") + "</html>"), (String)("<html><b>" + Internationalization.getLiteralFor((String)"ARE_YOU_SURE_YOU_WISH_TO_PROCEED") + "</b><html>"), (String)Internationalization.getLiteralFor((String)"PROCEED"), (String)Internationalization.getLiteralFor((String)"CANCEL"), (boolean)true)) {
            return;
        }
        AdjustTimePanel panel = new AdjustTimePanel();
        Calendar currentTime = Calendar.getInstance();
        panel.setTime(currentTime.get(11), currentTime.get(12));
        if (Dialogs.displayDialog((JComponent)panel, (String)Internationalization.getLiteralFor((String)"ADJUST_TIME"), (boolean)true)) {
            currentTime.set(11, panel.getHour());
            currentTime.set(12, panel.getMinute());
            if (AdjustTime.isTimeValid(currentTime)) {
                AdjustTime.performAdjustment(currentTime);
                SwingUtilities.invokeLater((Runnable)new RestartWaitermateTask());
            } else {
                OrderMate.LOG.warn("Did not allow time to be changed to:" + currentTime.getTime() + " Now:" + new Date());
            }
        }
    }

    private static boolean isTimeValid(Calendar newTime) {
        Calendar rightNow = Calendar.getInstance();
        if (newTime.get(5) != rightNow.get(5)) {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"THE_DATE_HAS_ROLLED_TO_THE_NEXT_DAY_THE_TIME_WILL_NOT_BE_CHANGED") + "<br><br>" + Internationalization.getLiteralFor((String)"PLEASE_TRY_AGAIN_IN_A_FEW_MINUTES") + "</html>"), (String)Internationalization.getLiteralFor((String)"WILL_NOT_CHANGE_TIME"));
            return false;
        }
        Calendar todayChangeOfDayTime = Calendar.getInstance();
        Calendar changeOfDayTime = Calendar.getInstance();
        changeOfDayTime.setTime(SystemProperty.getInstance().getChangeDayTime());
        todayChangeOfDayTime.set(11, changeOfDayTime.get(11));
        todayChangeOfDayTime.set(12, changeOfDayTime.get(12));
        todayChangeOfDayTime.set(13, 0);
        todayChangeOfDayTime.set(14, 0);
        Date changeOfDay = todayChangeOfDayTime.getTime();
        if (rightNow.getTime().compareTo(changeOfDay) < 0 && newTime.getTime().compareTo(changeOfDay) >= 0) {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"THE_NEW_TIME_WILL_CHANGE_THE_TRADING_DAY") + "<br><br>" + Internationalization.getLiteralFor((String)"PLEASE_TRY_AGAIN_NEXT_TRADING_DAY") + "</html>"), (String)Internationalization.getLiteralFor((String)"WILL_NOT_CHANGE_TIME"));
            return false;
        }
        if (rightNow.getTime().compareTo(changeOfDay) > 0 && newTime.getTime().compareTo(changeOfDay) <= 0) {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"THE_NEW_TIME_IS_BEFORE_THE_CHANGE_OF_TRADING_DAY") + "<br><br>" + Internationalization.getLiteralFor((String)"THE_TIME_WILL_NOT_BE_CHANGED") + "</html>"), (String)Internationalization.getLiteralFor((String)"WILL_NOT_CHANGE_TIME"));
            return false;
        }
        return true;
    }

    private static void performAdjustment(Calendar newTime) {
        if (Dialogs.displayChoiceDialog((String)("<html>" + Internationalization.getLiteralFor((String)"YOU_ARE_ABOUT_TO_SET_THE_TIME_TO_COLON") + "<b>" + DateFormat.getTimeInstance().format(newTime.getTime()) + "</b></html>"), (String)Internationalization.getLiteralFor((String)"CONFIRM_CHANGE"), (boolean)true)) {
            PersistenceManager.getServerConnection().runSync((Executable)new UpdateTimeTask(newTime.get(11), newTime.get(12)));
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"THE_TIME_CHANGE_REQUEST_HAS_BEEN_SENT_TO_THE_SERVER") + "<br><br><b>" + Internationalization.getLiteralFor((String)"THIS_TERMINAL_WILL_NOW_RESTART") + "</b><br>" + Internationalization.getLiteralFor((String)"PLEASE_RESTART_ANY_WAITERAMTE_TERMINALS_TO_SYNCHRONISE_THE_TIME") + "</html>"), (String)Internationalization.getLiteralFor((String)"TIME_MAY_HAVE_CHANGED"));
        }
    }
}

