/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.cashout;

import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.Payable;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.sales.TakeawayAccount;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.payment.debittransaction.DebitTransactionScreen;
import waitermate.guikit.dialogs.Dialogs;

public class CashOut {
    public Signal back = Signals.createSignal();
    private TakeawayAccount account;
    private DebitTransactionScreen cashoutScreen = new DebitTransactionScreen(true);

    public CashOut() {
        this.cashoutScreen.cancel.connect((Object)this, "gotCashoutCancelled");
        this.cashoutScreen.done.connect((Object)this, "gotCashoutDone");
    }

    public void gotStartCashout() {
        this.account = new TakeawayAccount(LoginManager.getInstance().getUser(), Terminal.getLocalHost());
        this.account.lock(LoginManager.getInstance().getUser());
        this.cashoutScreen.startAddingTransaction(Price.ZERO_DOLLAR, (Payable)this.account);
    }

    public void gotCashoutCancelled() {
        OrderMate.LOG.info("User has requested a cancellation");
        this.back.emit();
    }

    public void gotCashoutDone() {
        if (this.account == null) {
            OrderMate.LOG.info("Arrived into cashout without an account.");
            return;
        }
        OrderMate.LOG.info("Cashout cycle is completed.");
        if (this.account.getFinanceTransactions() != null && this.account.getFinanceTransactions().size() > 0) {
            EftposTransaction txn = (EftposTransaction)this.account.getFinanceTransactions().get(0);
            if (txn.getSystemState().equals("ACTIVE") && txn.getTransactionStatus().equals((Object)EftposTransaction.TransactionStatus.PROCESSED)) {
                WaitermateSaveAccount.getInstance().closeAccount((Account)this.account, true, true, LoginManager.getEventContext());
                Dialogs.displayOkDialog((String)("<html><h2>" + Internationalization.getLiteralFor((String)"TRANSACTION_APPROVED") + ": " + txn.getCashOut() + "</h2</html"), (String)("<html><h1>" + Internationalization.getLiteralFor((String)"CASHOUT") + "</h1></html>"));
                this.account.unlock();
                this.account = null;
                this.back.emit();
            }
            OrderMate.LOG.info("Cashout Transaction is " + txn.getSystemState() + " with status " + txn.getTransactionStatus());
        }
    }
}

