/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts.closedaccountslist;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.AccountSearchPanel;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.AccountTypeDrawerPanel;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.PaymentTypeDrawerPanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.components.DrawerToggleButton;

public class ClosedAccountListNavBar
extends NavBar
implements ActionListener {
    private StandardSecurityDecorator selectOneDecorator;
    private JButton selectOneButton;
    private StandardSecurityDecorator selectManyDecorator;
    private JButton selectManyButton;
    private StandardSecurityDecorator trainingModeDecorator;
    private JButton trainingModeButton;
    private DrawerToggleButton searchDrawer;
    private DrawerToggleButton accountTypeDrawer;
    private DrawerToggleButton paymentTypeDrawer;
    public final Signal startQuickTraining = Signals.createSignal();
    public final Signal stopQuickTraining = Signals.createSignal();
    public final Signal training = Signals.createSignal();
    private boolean isQuickTrainingMode = false;

    public ClosedAccountListNavBar(AccountSearchPanel newSearchPanel, AccountTypeDrawerPanel newAccountTypePanel, PaymentTypeDrawerPanel newPaymentTypesPanel) {
        this.selectOneButton = this.constructButton(IconLoader.get((String)"/waitermate/images/empty.png"), Internationalization.getLiteralFor((String)"SELECT_ONE"), "Select One");
        this.selectOneDecorator = new StandardSecurityDecorator((JComponent)this.selectOneButton, AllPermissions.TRAINING_MODE);
        this.selectManyButton = this.constructButton(IconLoader.get((String)"/waitermate/images/allAccounts.png"), Internationalization.getLiteralFor((String)"SELECT_MANY"), "Select Many");
        this.selectManyDecorator = new StandardSecurityDecorator((JComponent)this.selectManyButton, AllPermissions.TRAINING_MODE);
        this.trainingModeButton = this.constructButton(IconLoader.get((String)"/waitermate/images/trainingmode.png"), Internationalization.getLiteralFor((String)"ALLOCATE_TO_TRAINING"), "Training");
        this.trainingModeDecorator = new StandardSecurityDecorator((JComponent)this.trainingModeButton, AllPermissions.TRAINING_MODE);
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "newUser");
        if (newSearchPanel == null) {
            throw new IllegalArgumentException("Cannot instantiate NavBar with no search panel");
        }
        this.searchDrawer = this.constructDrawerToggleButton(Internationalization.getLiteralFor((String)"SEARCH"));
        this.searchDrawer.setDrawer((JComponent)newSearchPanel);
        if (newAccountTypePanel != null) {
            this.accountTypeDrawer = this.constructDrawerToggleButton(Internationalization.getLiteralFor((String)"ACCOUNT_TYPE"));
            this.accountTypeDrawer.setDrawer((JComponent)((Object)newAccountTypePanel));
        }
        if (newPaymentTypesPanel != null) {
            this.paymentTypeDrawer = this.constructDrawerToggleButton(Internationalization.getLiteralFor((String)"PAYMENT_TYPE"));
            this.paymentTypeDrawer.setDrawer((JComponent)((Object)newPaymentTypesPanel));
        }
        this.getClearButton().setText("<HTML>" + Internationalization.getLiteralFor((String)"RESET") + "<BR>" + Internationalization.getLiteralFor((String)"FILTER") + "</HTML>");
    }

    public void newUser(User newUser) {
        this.trainingModeDecorator.setVisible(newUser.hasPermission(AllPermissions.TRAINING_MODE));
    }

    public void setup() {
        this.removeRight((Component)this.selectManyDecorator);
        this.removeRight((Component)this.trainingModeDecorator);
        this.addLeft(this.getBackButton());
        if (this.searchDrawer != null) {
            this.addLeft((Component)this.searchDrawer);
        }
        if (this.accountTypeDrawer != null) {
            this.addLeft((Component)this.accountTypeDrawer);
        }
        if (this.paymentTypeDrawer != null) {
            this.addLeft((Component)this.paymentTypeDrawer);
        }
        if (this.accountTypeDrawer != null || this.searchDrawer != null || this.paymentTypeDrawer != null) {
            this.addLeft(this.getClearButton());
        }
        if (Config.getBooleanValue((String)"QuickTrain") && SystemProperty.getInstance().isTrainingModeEnabled()) {
            this.addRight((Component)this.selectOneDecorator);
        }
        this.setText("");
        this.isQuickTrainingMode = false;
    }

    public void setLabel(int nAccts, Price total) {
        this.setText(nAccts + " " + Internationalization.getLiteralFor((String)"ACCOUNTS_SELECTED_TOTALING") + " " + total);
    }

    public boolean isQuickTrainingMode() {
        return this.isQuickTrainingMode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object source = e.getSource();
        if (source == this.selectOneButton) {
            this.removeRight((Component)this.selectOneDecorator);
            this.addRight((Component)this.trainingModeDecorator);
            this.addRight((Component)this.selectManyDecorator);
            this.setLabel(0, new Price(0.0));
            this.isQuickTrainingMode = true;
            this.startQuickTraining.emit();
        } else if (source == this.selectManyButton) {
            this.removeRight((Component)this.selectManyDecorator);
            this.removeRight((Component)this.trainingModeDecorator);
            this.addRight((Component)this.selectOneDecorator);
            this.setText("");
            this.isQuickTrainingMode = false;
            this.stopQuickTraining.emit();
        } else if (source == this.trainingModeButton) {
            this.training.emit();
        }
    }
}

