/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts.closedoptions;

import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.CashDrawerTakingsSummary;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.finance.reports.SalesSummary;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.sales.AccountType;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.screens.admin.closedaccounts.closedoptions.ClosedOptionsGui;
import waitermate.gui.screens.admin.reports.WaitermateReports;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

public class ClosedOptions
extends AbstractScreen {
    private ClosedOptionsGui gui;
    private NavBar nav;
    public final Signal back = Signals.createSignal();
    public final Signal viewTakings = Signals.createSignal();
    public final Signal optionsSelected = Signals.createSignal(AccountType.class, (String)"Account Type", Shift.class, (String)"shift");
    public WaitermateReports reportsScreen;

    public ClosedOptions() {
        this.gui = new ClosedOptionsGui();
        this.gui.accountSelected.connect((Object)this, "gotType");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.setText(Internationalization.getLiteralFor((String)"VIEW_CLOSED_ACCOUNTS"));
        this.nav.back.connect((Object)this, "exitDisplay");
        JButton printSales = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/print.png"), Internationalization.getLiteralFor((String)"PRINT_SALES"), "Print Sales");
        printSales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClosedOptions.this.gotPrintSales();
            }
        });
        this.nav.addRight((Component)new StandardSecurityDecorator((JComponent)printSales, AllPermissions.PRINT_SALES));
        this.nav.addRight((Component)new StandardSecurityDecorator((JComponent)this.nav.getPrintButton(), AllPermissions.PRINT_TAKINGS));
        this.nav.print.connect((Object)this, "printDocket");
        this.nav.getPrintButton().setText(Internationalization.getLiteralFor((String)"PRINT_TAKINGS"));
        JButton viewTakingsButton = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/images/pay.png"), Internationalization.getLiteralFor((String)"VIEW_TAKINGS"), "viewTakings", this.viewTakings);
        this.nav.addRight((Component)new StandardSecurityDecorator((JComponent)viewTakingsButton, AllPermissions.VIEW_TAKINGS));
        this.viewTakings.connect((Object)this, "gotViewTakings");
    }

    void exitDisplay() {
        this.reportsScreen = null;
        this.back.emit();
    }

    void gotType(AccountType type) {
        this.optionsSelected.emit((Object)type, (Object)this.gui.getShift());
    }

    public void printDocket() {
        Terminal localhost = Terminal.getLocalHost();
        Shift shift = this.gui.getShift();
        List cashdrawers = localhost.getAvailableLogicallyConnectedCashDrawers();
        ArrayList<CashDrawerTakingsSummary> currentCashdrawerSummay = new ArrayList<CashDrawerTakingsSummary>(cashdrawers.size());
        for (CashDrawer cashdrawer : cashdrawers) {
            currentCashdrawerSummay.add(CashDrawerTakingsSummary.getSummary((CashDrawer)cashdrawer, (Shift)shift));
        }
        RestaurantTakingsSummary currentTakingsSummary = RestaurantTakingsSummary.getSummary((Shift)shift);
        ProgressDialog.doProgressDialog((Task)currentTakingsSummary.getCalculateTask());
        List printers = localhost.getAvailableReceiptPrinters();
        try {
            DocketProcessor.printTakingsDocket((User)LoginManager.getInstance().getUser(), (Terminal)localhost, (RestaurantTakingsSummary)currentTakingsSummary, currentCashdrawerSummay, (Collection)printers);
        }
        catch (IOException e) {
            WaiterMate.LOG.error("Couldn't print takings docket", (Throwable)e);
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"ERROR_PRINTNG_TAKINGS_DOCKET"), (String)Internationalization.getLiteralFor((String)"ERROR"));
        }
    }

    public void gotPrintSales() {
        SalesSummary summary = SalesSummary.getSummary((Shift)this.gui.getShift());
        ProgressDialog.doProgressDialog((Task)summary.getCalculateTask());
        Terminal thisTerminal = Terminal.getLocalHost();
        List printers = thisTerminal.getAvailableReceiptPrinters();
        try {
            DocketProcessor.printSalesDocket((User)LoginManager.getInstance().getUser(), (Terminal)thisTerminal, (Collection)printers, (SalesSummary)summary);
        }
        catch (IOException e) {
            WaiterMate.LOG.error("Couldn't print takings docket", (Throwable)e);
        }
    }

    public void gotViewTakings() {
        if (this.reportsScreen == null) {
            this.reportsScreen = new WaitermateReports();
            this.reportsScreen.done.connect((Object)this, "display");
        }
        this.reportsScreen.start(this.gui.getShift());
    }

    public void selectClosedOptions() {
        this.gui.refreshTradingDays();
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }
}

