/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts.viewclosedaccount;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.database.Lockable;
import ordermate.database.Payable;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.VoucherTopupReversalHelper;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.users.User;
import ordermate.gui.SaveAccount;
import ordermate.integration.cloudback.nudge.NudgeUtil;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.displayitems.accountitems.CourseItemsPanel;
import waitermate.gui.displayitems.accountitems.DefaultItemRenderer;
import waitermate.gui.screens.admin.closedaccounts.ClosedAccountRefundHelper;
import waitermate.gui.screens.admin.closedaccounts.viewclosedaccount.ClosedAccountItemSignals;
import waitermate.gui.screens.admin.closedaccounts.viewclosedaccount.ClosedAccountNav;
import waitermate.gui.screens.admin.closedaccounts.viewclosedaccount.WaiterMateEmailTaxInvoiceAction;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.ordering.transferitems.selectitems.SplitSelectItems;
import waitermate.gui.screens.payment.transactions.AccountPaymentsScreen;
import waitermate.gui.screens.payment.transactions.PaymentsNav;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.showitem.ShowItemsUtils;

public class ClosedAccountItems
extends AbstractScreen {
    private final ClosedAccountNav navBar;
    private final CourseItemsPanel items;
    private final AccountPaymentsScreen transactions = new AccountPaymentsScreen();
    private final SplitSelectItems selectItemsToRefund = new SplitSelectItems(false, true);
    private final Signal refreshSignal = Signals.createSignal();
    private final Signal startSelectSignal = Signals.createSignal();
    private Account currentAccount;
    private ClosedAccountItemSignals signals;
    protected SellableWrapperFactory sellableFactory = new SellableWrapperFactory();
    private VoucherTopupReversalHelper reversalHelper = new VoucherTopupReversalHelper();
    private final WaiterMateEmailTaxInvoiceAction emailReceiptAction;
    private static ClosedAccountItems instance;

    public static final ClosedAccountItems getInstance(ClosedAccountItemSignals signals) {
        if (instance == null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            instance = new ClosedAccountItems();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                instance = new ClosedAccountItems();
            }
        }
        instance.configureSignals(signals);
        instance.getNavBar().getOkButton().setVisible(true);
        return instance;
    }

    private ClosedAccountItems() {
        DefaultItemRenderer renderer = new DefaultItemRenderer(false);
        this.items = new CourseItemsPanel(renderer);
        this.navBar = new ClosedAccountNav();
        this.navBar.save.connect((Object)this, "gotOk");
        this.navBar.back.connect((Object)this, "gotBack");
        this.navBar.payment.connect((Object)this, "gotPayment");
        this.navBar.print.connect((Object)this, "gotPrintBill");
        this.navBar.financeInfo.connect((Object)this, "gotShowFinanceInfo");
        this.navBar.showItems.connect((Object)this, "gotShowItems");
        this.navBar.training.connect((Object)this, "gotTrainingMode");
        this.emailReceiptAction = new WaiterMateEmailTaxInvoiceAction(new NudgeUtil(), (ItemGroup)this.currentAccount);
        this.navBar.getEmailTaxInvoiceButton().setAction((Action)((Object)this.emailReceiptAction));
        this.selectItemsToRefund.itemsSplit.connect((Object)this, "gotItemsSplit");
        this.selectItemsToRefund.back.connect((Object)this, "display");
        this.selectItemsToRefund.items.connect((Object)this, "gotItemsToRefund");
        this.navBar.refundSignal.connect((Object)this, "gotRefund");
        this.transactions.done.connect((Object)this, "transactionsDone");
        this.transactions.back.connect((Object)this, "transactionsBack");
        this.transactions.voucherReversalDone.connect((Object)this, "gotVoucherReversal");
        this.refreshSignal.connect((Object)this, "refreshItems");
        this.startSelectSignal.connect((Object)this, "doStartSelectItems");
        ((PaymentsNav)this.transactions.getNavBar()).getBreakComboButton().setEnabled(false);
        ((PaymentsNav)this.transactions.getNavBar()).getCreateComboButton().setEnabled(false);
    }

    void configureSignals(ClosedAccountItemSignals newSignals) {
        this.signals = newSignals;
    }

    void doStartSelectItems() {
        this.startSelectItems(this.currentAccount);
    }

    public void startSelectItems(Account newAccount) {
        if (newAccount == null) {
            throw new NullPointerException("Cannot start selecting items on null account");
        }
        TerminalEventLog.logClosedAccount((User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost(), (ItemGroup)newAccount);
        if (this.currentAccount != null) {
            this.currentAccount.unlock();
        }
        this.setCurrentAccount(newAccount);
        if (!LoginManager.getInstance().getUser().equals((Object)this.currentAccount.getUser()) && !WaitermateSaveAccount.getInstance().lockAccount((Lockable)newAccount)) {
            this.gotBack();
        } else {
            this.items.setCourse(0);
            this.items.setSeat(0);
            this.refreshItems();
            this.navBar.getBackButton().setEnabled(true);
            this.selectItems();
        }
    }

    public void selectItems() {
        this.navBar.setup(this.getCurrentAccount().isDebtorSale());
        if (Terminal.getLocalHost().getSeatNums() && this.getCurrentAccount().usesSeatNums()) {
            this.items.setNumSeats(CoversHelper.getValueForSeats((ItemGroup)this.getCurrentAccount()));
        } else {
            this.items.setNumSeats(0);
        }
        this.refreshItems();
        this.display();
    }

    private void gotOk() {
        boolean isRefund;
        boolean bl = isRefund = !this.getCurrentAccount().getTotal().equals((Object)this.getCurrentAccount().getPaid()) && !this.getCurrentAccount().isOpen();
        if (isRefund && this.getCurrentAccount().isDebtorSale()) {
            Price total = this.getCurrentAccount().getPaid().add(this.getCurrentAccount().getUniqueDebtorSale().getAmount());
            isRefund = this.getCurrentAccount().getTotal().equals((Object)total);
        }
        if (isRefund) {
            this.doRefund();
        }
        if (isRefund) {
            this.doRefund();
        } else {
            WaitermateSaveAccount.getInstance().saveAccount(this.getCurrentAccount(), LoginManager.getEventContext());
            this.getCurrentAccount().unlock();
            this.setCurrentAccount(null);
            this.signals.ok.emit();
        }
    }

    private boolean doRefund() {
        ClosedAccountRefundHelper carHelper = new ClosedAccountRefundHelper(this.getCurrentAccount(), this.sellableFactory, this.transactions, this.reversalHelper);
        return carHelper.doRefund();
    }

    void gotBack() {
        if (this.getCurrentAccount() != null) {
            this.currentAccount.unlock();
            this.setCurrentAccount(null);
        }
        this.signals.back.emit();
    }

    private void refreshItems() {
        this.getCurrentAccount().refreshVoucherTxns();
        List sellables = this.sellableFactory.getSellables((ItemGroup)this.getCurrentAccount());
        this.items.setItems(sellables);
        boolean canPay = !Terminal.getLocalHost().getPayableCashDrawers(LoginManager.getInstance().getUser()).isEmpty();
        this.navBar.setRefundButtonVisible(canPay && !sellables.isEmpty() && !this.getCurrentAccount().isDebtorSale() && (!SystemProperty.getInstance().isSinglePaymentMode() || SystemProperty.getInstance().isSinglePaymentMode() && this.getCurrentAccount().getTradingDay().equals((Object)TradingDay.getCurrentTradingDay())));
        this.navBar.setPaymentButtonVisible(canPay);
        this.navBar.getBackButton().setEnabled(this.getCurrentAccount().isDebtorSale() || Price.ZERO_DOLLAR.equals((Object)this.getCurrentAccount().getDue()) || this.getCurrentAccount().isOpen());
    }

    void gotPrintBill() {
        WaitermateSaveAccount.getInstance().printReceiptDockets((ItemGroup)this.getCurrentAccount());
    }

    void gotPayment() {
        if (!this.getCurrentAccount().getTotal().equals((Object)this.getCurrentAccount().getPaid())) {
            if (!this.getCurrentAccount().isDebtorSale()) {
                this.gotOk();
            } else {
                DebtorSale sale = this.getCurrentAccount().getUniqueDebtorSale();
                if (!this.getCurrentAccount().getTotal().equals((Object)this.getCurrentAccount().getPaid().add(sale.getAmount()))) {
                    this.gotOk();
                } else {
                    this.gotTransactions(this.getCurrentAccount());
                }
            }
        } else {
            this.gotTransactions(this.getCurrentAccount());
        }
    }

    public JComponent getMainArea() {
        return this.items;
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    void gotShowFinanceInfo() {
        Price surchargeTotal = Price.ZERO_DOLLAR;
        Price tipTotal = Price.ZERO_DOLLAR;
        Price paidTotal = Price.ZERO_DOLLAR;
        String financeString = "<html>";
        if (this.getCurrentAccount().isDebtorSale()) {
            financeString = financeString + "<p>" + Internationalization.getLiteralFor((String)"THIS_ACCOUNT_WAS_TRANSFERRED_TO_DEBTOR") + " " + this.getCurrentAccount().getDebtor().getLabel() + ".<BR>" + Internationalization.getLiteralFor((String)"REFUNDS_MUST_BE_DONE_THROUGH_THE_DEBTOR_SCREEN") + "</p>";
            financeString = financeString + "<p align=\"right\">" + Internationalization.getLiteralFor((String)"ITEM_TOTAL") + ": " + this.getCurrentAccount().getTotal() + "</p>";
            financeString = financeString + "</html>";
        } else {
            SimpleDateFormat format = new SimpleDateFormat("h:mm a");
            for (FinanceTransaction txn : this.getCurrentAccount().getFinanceTransactions()) {
                Price paid = txn.getPaid();
                Price tip = txn.getTip();
                if (tip != null && !Price.ZERO_DOLLAR.equals((Object)tip)) {
                    paid = paid.add(tip);
                }
                paidTotal = paidTotal.add(paid);
                Date transactionTime = txn.getCreationTime();
                String time = format.format(transactionTime);
                financeString = financeString + "<b>" + paid + "</b> ";
                if (txn instanceof CashTransaction) {
                    financeString = financeString + "(Tendered " + txn.getTendered() + ") ";
                }
                financeString = financeString + txn.getSubType().getLabel();
                if (!StringUtils.isEmpty((String)txn.getSource())) {
                    financeString = financeString + " by " + txn.getSource();
                }
                if (txn.getSurcharge() != null && !Price.ZERO_DOLLAR.equals((Object)txn.getSurcharge())) {
                    surchargeTotal = surchargeTotal.add(txn.getSurcharge());
                    financeString = financeString + ", Sur: " + txn.getSurcharge();
                }
                if (txn.getTip() != null && !Price.ZERO_DOLLAR.equals((Object)txn.getTip())) {
                    tipTotal = tipTotal.add(txn.getTip());
                    financeString = financeString + ", Tip: " + txn.getTip();
                }
                financeString = financeString + "<br>" + Internationalization.getLiteralFor((String)"ENTERED") + " " + time + " " + Internationalization.getLiteralFor((String)"BY") + " " + txn.getUser() + " " + Internationalization.getLiteralFor((String)"ON_") + " " + txn.getTerminal().getName();
                financeString = financeString + "<br>";
            }
            financeString = financeString + "<br><table align=\"right\">";
            financeString = financeString + "<tr><td>" + Internationalization.getLiteralFor((String)"TRANSACTION_TOTAL") + "</td><td align=\"right\">" + paidTotal + "</td></tr>";
            if (!Price.ZERO_DOLLAR.equals((Object)surchargeTotal)) {
                financeString = financeString + "<tr color=\"gray\"><td>Surcharge total</td><td align=\"right\">" + surchargeTotal + "</td></tr>";
            }
            if (!Price.ZERO_DOLLAR.equals((Object)tipTotal)) {
                financeString = financeString + "<tr><td>Tip total</td><td align=\"right\">(" + tipTotal + ")</td></tr>";
            }
            financeString = financeString + "<tr><td>" + Internationalization.getLiteralFor((String)"ITEM_TOTAL") + "</td><td align=\"right\">" + this.getCurrentAccount().getTotal() + "</td></tr>";
            financeString = financeString + "</table>";
            financeString = financeString + "</html>";
        }
        Dialogs.displayOkDialog((String)financeString, (String)Internationalization.getLiteralFor((String)"FINANCE_TRANSACTIONS"));
    }

    void gotShowItems() {
        new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showItems((ItemGroup)this.getCurrentAccount());
    }

    void gotTrainingMode() {
        Account account = this.getCurrentAccount();
        List voucherTxns = account.getVoucherTxns();
        if (voucherTxns != null && voucherTxns.size() > 0) {
            Dialogs.displayOkDialog((String)HtmlUtils.html((String)Internationalization.getLiteralFor((String)"CANNOT_ASSIGN_TO_TRAINING_FOR_VOUCHERS")), (String)Internationalization.getLiteralFor((String)"ALLOCATE_TO_TRAINING"));
        } else if (Dialogs.displayChoiceDialog((String)HtmlUtils.html((String)(Internationalization.getLiteralFor((String)"IF_YOU_ALLOCATE_THIS_ACCOUNT_TO_TRAINING_MODE_IT_WILL_BE_PERMANENTELY_DELETED_AND_CANNOT_BE_UNDONE_1") + "<br>" + Internationalization.getLiteralFor((String)"IF_YOU_ALLOCATE_THIS_ACCOUNT_TO_TRAINING_MODE_IT_WILL_BE_PERMANENTELY_DELETED_AND_CANNOT_BE_UNDONE_2") + "<br>" + Internationalization.getLiteralFor((String)"ARE_YOU_SURE_YOU_WANT_TO_CONTINUE"))), (String)Internationalization.getLiteralFor((String)"ALLOCATE_TO_TRAINING"), (boolean)true)) {
            this.getCurrentAccount().removeAllItems(LoginManager.getEventContext());
            WaitermateSaveAccount.getInstance().saveAccount(this.getCurrentAccount(), LoginManager.getEventContext());
            this.getCurrentAccount().nukeAccount();
            this.signals.ok.emit();
        }
    }

    void gotRefund() {
        this.selectItemsToRefund.startSelection(this.sellableFactory.getSellables((ItemGroup)this.getCurrentAccount()));
    }

    void gotItemsToRefund(Set selectedItems) {
        ClosedAccountRefundHelper carHelper = new ClosedAccountRefundHelper(this.getCurrentAccount(), this.sellableFactory, this.transactions, this.reversalHelper);
        carHelper.gotItemsToRefund(selectedItems, this.refreshSignal, this.startSelectSignal);
    }

    void gotItemsSplit() {
        this.getCurrentAccount().save();
    }

    private void setCurrentAccount(Account newAccount) {
        this.currentAccount = newAccount;
        this.emailReceiptAction.setItemGroup((ItemGroup)newAccount);
    }

    private Account getCurrentAccount() {
        return this.currentAccount;
    }

    void gotTransactions(Account toDisplay) {
        Account reacquiredAccount = (Account)PersistenceManager.reacquire((PersistentObjectI)this.currentAccount);
        this.setCurrentAccount(reacquiredAccount);
        this.transactions.startTransactions((Payable)this.currentAccount, true, false);
    }

    void transactionsDone() {
        WaitermateSaveAccount.getInstance().saveAccount(this.currentAccount, LoginManager.getEventContext());
        this.currentAccount.unlock();
        this.gotBack();
    }

    void transactionsBack() {
        this.startSelectItems(this.currentAccount);
    }

    void gotVoucherReversal(ItemGroup account) {
        if (account instanceof Account) {
            this.setCurrentAccount((Account)account);
        }
    }
}

