/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts.viewclosedaccount;

import au.com.ordermate.dockets.HtmlReceiptCommander;
import au.com.ordermate.dockets.PrintCommanderInterface;
import au.com.ordermate.dockets.XMLDocketScanner;
import au.com.ordermate.message.Email;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.queries.hardware.ReceiptPrinterQueries;
import ordermate.database.sales.ItemGroup;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;
import ordermate.integration.cloudback.nudge.NudgeUtil;
import ordermate.integration.nudgeback.EmailBuilder;
import ordermate.reports.printing.InvoiceReport;
import org.xml.sax.SAXException;
import waitermate.LoginManager;
import waitermate.gui.actions.WaiterMatePermissibleAction;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

public class WaiterMateEmailTaxInvoiceAction
extends WaiterMatePermissibleAction {
    private final NudgeUtil nudgeUtil;
    private ItemGroup itemGroup;
    public static String NAME = "Email Tax Invoice";
    public static Icon ICON = IconLoader.get((String)"/waitermate/images/newsletter.png");

    public WaiterMateEmailTaxInvoiceAction(NudgeUtil nudgeUtil, ItemGroup itemGroup) {
        super(NAME, AllPermissions.EMAIL_TAX_INVOICES_WAITERMATE, ICON);
        this.nudgeUtil = nudgeUtil;
        this.itemGroup = itemGroup;
    }

    public ItemGroup getItemGroup() {
        return this.itemGroup;
    }

    public void setItemGroup(ItemGroup itemGroup) {
        this.itemGroup = itemGroup;
    }

    public void actionPerformed(ActionEvent e) {
        String emailBody;
        String recipients = Dialogs.getString((String)"Enter email addresses:", (String)"", (boolean)true, (String)"", (String)"<html>HINT: separate multiple email addresses with a semicolon (<b>;</b>)</html>");
        if (recipients.isEmpty() || recipients.equals("\u0000")) {
            return;
        }
        try {
            emailBody = this.getInvoiceEmail(this.getItemGroup(), LoginManager.getInstance().getUser());
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            OrderMate.LOG.error("Failed to create XML tax invoice string", (Throwable)ex);
            emailBody = "";
        }
        EmailBuilder emailBuilder = new EmailBuilder("Tax invoice from " + BusinessInfo.getInstance().getName(), emailBody, true, recipients);
        File createdFile = null;
        JDialog createReportProgressDialog = ProgressDialog.doIndeterminateProgress((String)"Creating tax invoice report", null);
        try {
            String businessNameNoSpaces = BusinessInfo.getInstance().getName().replace(' ', '_');
            String fileName = String.format("C:\\Temp\\%s-Tax_Invoice-%s.pdf", businessNameNoSpaces, this.itemGroup.getID());
            InvoiceReport invoiceReport = new InvoiceReport(this.itemGroup, "/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
            invoiceReport.generate();
            JasperPrintManager.printReportToPdfFile((JasperPrint)invoiceReport.getReport(), (String)fileName);
            createdFile = new File(fileName);
        }
        catch (JRException ex) {
            OrderMate.LOG.error("Failed to generate InvoiceReport or print InvoiceReport to PDF for Account " + this.itemGroup.getID(), (Throwable)ex);
        }
        createReportProgressDialog.dispose();
        if (createdFile == null) {
            return;
        }
        Email toSend = emailBuilder.addAttachment(createdFile).build();
        boolean succeeded = this.nudgeUtil.sendEmail(toSend);
        if (succeeded) {
            Dialogs.displayOkDialog((String)"Tax Invoice was successfully emailed!", (String)"");
        } else {
            Dialogs.displayOkDialog((String)"Something went wrong while emailing tax invoice!", (String)"");
        }
    }

    private String getInvoiceEmail(ItemGroup itemGroup, User user) throws ParserConfigurationException, IOException, SAXException {
        ArrayList<Object> docketParams = new ArrayList<Object>();
        docketParams.add(itemGroup);
        docketParams.add(1);
        docketParams.add(user);
        docketParams.add(ReceiptPrinterQueries.getReceiptPrintersForTerminal((Terminal)Terminal.getServerMateTerminal()));
        XmlDocket docket = GroovyDocket.getReceiptDocket(null);
        docket.setParams(docketParams);
        docket.setTemplate(DocketTemplate.getHighestTemplate((DocketTemplate.DocketType)DocketTemplate.DocketType.RECEIPT, (TriggerActivationContext)new TriggerActivationContext(new EventContext(Terminal.getServerMateTerminal(), user), itemGroup)));
        String receiptStr = docket.generateXml();
        XMLDocketScanner scanner = new XMLDocketScanner((PrintCommanderInterface)new HtmlReceiptCommander(100));
        return scanner.visitDocument(receiptStr, false);
    }
}

