/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.completeddeliveries;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ordermate.database.Lockable;
import ordermate.database.finance.Shift;
import ordermate.database.sales.Delivery;
import ordermate.gui.ShiftSelector;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.dialogs.UnlockDialog;

class SelectDeliveryGui
extends JPanel {
    public final Signal delivery = Signals.createSignal(Delivery.class, (String)"Selected Delivery");
    private CustomScrollPane gui;
    private DataScrollPaneModel accounts;
    private UnlockDialog unlockDialog;
    private ShiftSelector shifts;

    public SelectDeliveryGui() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(7, 20)));
        this.accounts = new DataScrollPaneModel();
        this.accounts.objectSelected.connect((Object)this, "gotDelivery");
        this.gui = new CustomScrollPane((CustomScrollPaneModel)this.accounts);
        this.gui.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_COMPLETED_DELIVERIES_FOR_THIS_DAY"));
        this.add((Component)this.gui, new Rectangle(0, 6, 7, 14));
        this.shifts = new ShiftSelector();
        this.shifts.setTextFont(OrderMateTheme.getMediumFont());
        this.shifts.shift.connect((Object)this, "displayDeliveries");
        this.shifts.setBorder((Border)new CompoundBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SELECT_DAY_SHIFT") + " :"), new EmptyBorder(0, 5, 5, 5)));
        this.add((Component)this.shifts, new Rectangle(2, 1, 3, 4));
        this.unlockDialog = new UnlockDialog();
    }

    public void reloadShifts() {
        this.shifts.setShifts(Shift.getShifts());
    }

    public void displayDeliveries() {
        this.showCompletedDeliveries(this.shifts.getShift());
    }

    public void refresh() {
        int currentPage = this.gui.getCurrentPage();
        this.showCompletedDeliveries(this.shifts.getShift());
        if (currentPage != this.gui.getCurrentPage()) {
            this.gui.displayPage(currentPage);
        }
    }

    private void showCompletedDeliveries(Shift theShift) {
        List accountList = Delivery.getCompletedDeliveries((Shift)theShift);
        if (accountList != null) {
            this.accounts.setItems(accountList);
        }
    }

    void gotDelivery(Displayable selDelivery) {
        Delivery theDelivery = (Delivery)selDelivery;
        boolean doLock = true;
        if (theDelivery.isLocked()) {
            doLock = this.unlockDialog.display((Lockable)theDelivery, "Delivery");
        }
        if (doLock) {
            theDelivery.lock(LoginManager.getInstance().getUser());
            this.delivery.emit((Object)theDelivery);
        }
    }
}

