/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.daily.errorlog;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.internationalization.Internationalization;
import ordermate.startup.DeviceNotFoundException;
import ordermate.startup.StartupErrorManager;
import waitermate.guikit.NotificationManager;

public class ErrorLogRendererPanel
extends JPanel {
    private JLabel errorMessageLabel = new JLabel();
    private JButton retryButton;

    public ErrorLogRendererPanel() {
        super((LayoutManager)new GraphPaperLayout(12, 1));
        this.errorMessageLabel.setHorizontalAlignment(2);
        this.add((Component)this.errorMessageLabel, new Rectangle(0, 0, 8, 1));
        this.retryButton = new JButton();
        this.retryButton.setHorizontalAlignment(0);
        this.retryButton.setText(Internationalization.getLiteralFor((String)"RETRY"));
        this.add((Component)this.retryButton, new Rectangle(9, 0, 3, 1));
    }

    public void setData(final DeviceNotFoundException exception) {
        this.errorMessageLabel.setText(exception.getHTMLMessage());
        this.retryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StartupErrorManager.getInstance().retryDeviceNotFoundExceptionTask(exception)) {
                    NotificationManager.getInstance().checkAndHandleStartupErrors.emit();
                }
            }
        });
    }
}

