/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.daily.errorlog;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import ordermate.startup.DeviceNotFoundException;
import ordermate.startup.StartupErrorManager;
import waitermate.gui.screens.admin.daily.errorlog.ErrorLogRenderer;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class ErrorLogScreen
extends AbstractScreen {
    private final int ROWS_PER_PAGE = 10;
    public final Signal back = Signals.createSignal();
    private JPanel gui;
    private CustomScrollPane scrollPane;
    private RendererScrollPaneModel<DeviceNotFoundException> model;
    private NavBar nav;

    public JComponent getMainArea() {
        return this.getGUI();
    }

    public NavBar getNavBar() {
        return this.getNavigationBar();
    }

    private JPanel getGUI() {
        if (this.gui == null) {
            this.gui = new JPanel();
            this.gui.add((Component)this.getTable());
        }
        return this.gui;
    }

    private NavBar getNavigationBar() {
        if (this.nav == null) {
            this.nav = new NavBar();
            this.nav.addLeft((Component)this.nav.getBackButton());
            this.nav.back.connect((Object)this.back, "emit");
            this.nav.setText(Internationalization.getLiteralFor((String)"STARTUP_ERROR_LOG"));
        }
        return this.nav;
    }

    public void showErrorLog() {
        this.reloadData();
        this.display();
    }

    private CustomScrollPane getTable() {
        this.scrollPane = new CustomScrollPane(this.getModel());
        this.scrollPane.setDecorationLocation(DecoratorLocation.East);
        return this.scrollPane;
    }

    private RendererScrollPaneModel<DeviceNotFoundException> getModel() {
        if (this.model == null) {
            this.model = new RendererScrollPaneModel((Renderer)new ErrorLogRenderer());
            this.model.setColumns(1);
            this.model.setRowsPerPage(10);
        }
        return this.model;
    }

    private void reloadData() {
        if (StartupErrorManager.getInstance().hasStartupErrors()) {
            this.getModel().setObjects(StartupErrorManager.getInstance().getDeviceNotFoundErrors());
        } else {
            this.getModel().removeAllObjects();
        }
    }
}

