/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.daily.tipadjust;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.sales.ItemGroup;
import ordermate.internationalization.Internationalization;
import waitermate.LoginManager;
import waitermate.gui.screens.payment.eftpos.EftposController;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeypadDialog;

public class FastTipAdjust {
    private EftposController controller;
    private ItemGroup currentGroup;

    public void start() {
        this.controller = new EftposController();
        this.controller.eftposFinished.connect((Object)this, "gotAdjustDone");
        String reference = "";
        while (reference != null) {
            reference = this.getReferenceString();
            if (reference == null) continue;
            EftposTransaction txn = this.resolveReference(reference);
            if (txn != null) {
                Price price = this.doPrice(txn);
                if (price == null) continue;
                this.doAdjust(txn, price);
                continue;
            }
            Dialogs.displayOkDialog((String)"Unknown Reference", (String)(reference + " doesn't match any known transaction."));
        }
        this.controller.eftposFinished.disconnect((Object)this);
        this.controller = null;
    }

    private String getReferenceString() {
        KeypadDialog dialog = new KeypadDialog();
        dialog.setMaxChars(10);
        dialog.setUnits("Reference Number: ");
        if (Dialogs.displayDialog((JComponent)dialog, (String)"Enter Reference Number", (String)"OK", (String)"Close", (boolean)true, (boolean)true, (boolean)true)) {
            return dialog.getValueAsString();
        }
        return null;
    }

    private EftposTransaction resolveReference(String tipAuth) {
        ObjectQuery query = Query.select(CreditTransaction.class).equals(CreditTransaction.Properties.TIP_REFERENCE, (Object)tipAuth).active(CreditTransaction.class);
        return (EftposTransaction)PersistenceManager.getObject(CreditTransaction.class, (String)query.toString(), null);
    }

    private Price doPrice(EftposTransaction txn) {
        JPanel holder = new JPanel(new BorderLayout());
        KeypadDialog dialog = new KeypadDialog();
        dialog.setup(true);
        StringBuilder SB = new StringBuilder("<html>Transaction:");
        SB.append(txn.getCreationTime()).append("<br>Reference:").append(txn.getTipReference()).append("<br>Bill Amount:").append(txn.getPaid());
        holder.add((Component)new JLabel(SB.toString()), "North");
        dialog.setUnits("Tip Amount: " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        holder.add((Component)dialog, "Center");
        if (Dialogs.displayDialog((JComponent)holder, (String)"Enter Tip Amount", (String)"OK", (String)"Close", (boolean)true, (boolean)true, (boolean)true)) {
            return new Price(dialog.getValueAsPrice());
        }
        return null;
    }

    private void doAdjust(EftposTransaction txn, Price tipValue) {
        this.currentGroup = txn.getPayoffGroup();
        if (!this.currentGroup.lock(LoginManager.getInstance().getUser())) {
            Dialogs.displayOkDialog((String)("Account is in use by " + this.currentGroup.getUser() + ". Cannot adjust the tip."), (String)"Cannot lock account");
            return;
        }
        this.controller.performTipAdjust(txn, tipValue);
    }

    public void gotAdjustDone(EftposTransaction txn) {
        txn.saveChild();
        this.currentGroup.unlock();
    }
}

