/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.daily.triggers;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class TriggerActivationScreen
extends JPanel {
    private static final String FORCE_ACTIVE = "/waitermate/guikit/images/ok.png";
    private static final String FORCE_INACTIVE = "/waitermate/guikit/images/cancel.png";
    private static final String DEFAULT = "/waitermate/guikit/images/clear.png";
    private CustomScrollPane triggersScroll;
    private RendererScrollPaneModel<AbstractTrigger> triggersModel;

    public TriggerActivationScreen() {
        super(new BorderLayout(0, 20));
        List overrideableTriggers = PersistenceManager.getObjectList(AbstractTrigger.class, (String)Query.select(AbstractTrigger.class).active(AbstractTrigger.class).orderBy(AbstractTrigger.Properties.ID).equals(AbstractTrigger.Properties.CAN_OVERRIDE, (Object)"1").toString());
        if (overrideableTriggers.isEmpty()) {
            this.add(new JLabel(new HtmlBuilder().append("There are no active triggers that can be overridden").center().toString()));
        } else {
            this.triggersModel = new RendererScrollPaneModel((Renderer)new ManualTriggerRenderer(), 1, 7);
            this.triggersScroll = new CustomScrollPane(this.triggersModel);
            this.triggersModel.setObjects(overrideableTriggers);
            this.add((Component)this.triggersScroll, "Center");
            this.add((Component)this.makeLegendPanel(), "North");
        }
    }

    private JComponent makeLegendPanel() {
        JPanel holder = new JPanel(new GridLayout(1, 3));
        ImageHelper helper = new ImageHelper();
        holder.add(new JLabel("Default", new ImageIcon(helper.fitImageTo(IconLoader.getImage((String)DEFAULT), 25, 25)), 2));
        holder.add(new JLabel("Active", new ImageIcon(helper.fitImageTo(IconLoader.getImage((String)FORCE_ACTIVE), 25, 25)), 2));
        holder.add(new JLabel("Inactive", new ImageIcon(helper.fitImageTo(IconLoader.getImage((String)FORCE_INACTIVE), 25, 25)), 2));
        return holder;
    }

    class ManualTriggerRenderer
    implements Renderer,
    ActionListener {
        ManualTriggerRenderer() {
        }

        public Component createComponent() {
            CustomButton button = new CustomButton();
            button.setHorizontalTextPosition(2);
            button.setHorizontalAlignment(4);
            button.setIconTextGap(30);
            button.addActionListener((ActionListener)this);
            return button;
        }

        public void setupComponent(Component component, Object object, int index) {
            AbstractTrigger trigger = (AbstractTrigger)object;
            ((CustomButton)component).setData((Displayable)trigger);
            Boolean manual = trigger.getManualOverride();
            ImageIcon icon = null;
            icon = manual == null ? IconLoader.get((String)TriggerActivationScreen.DEFAULT) : (manual != false ? IconLoader.get((String)TriggerActivationScreen.FORCE_ACTIVE) : IconLoader.get((String)TriggerActivationScreen.FORCE_INACTIVE));
            ((CustomButton)component).setIcon((Icon)icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomButton button = (CustomButton)e.getSource();
            AbstractTrigger trigger = (AbstractTrigger)button.getData();
            if (trigger.getManualOverride() == null) {
                trigger.setManualOverride(Boolean.TRUE);
            } else if (trigger.getManualOverride().booleanValue()) {
                trigger.setManualOverride(Boolean.FALSE);
            } else {
                trigger.setManualOverride(null);
            }
            trigger.save();
            CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable("ordermate.database.workflow.WorkflowManager", new String[]{"getInstance", "updateWorkflowTriggers"});
            PersistenceManager.getServerConnection().runSync((Executable)exec);
            this.setupComponent((Component)button, trigger, 0);
        }
    }
}

