/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.guiconfig;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.gui.LaFManager;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jvnet.substance.SubstanceLookAndFeel;
import waitermate.LoginManager;
import waitermate.gui.screens.admin.guiconfig.GuiConfigPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;

public class GuiConfig
extends AbstractScreen {
    private final GuiConfigPanel panel;
    private final NavBar nav = new NavBar();
    private final JButton resetButton;
    private final LaFManager lafManager = new LaFManager();
    public final Signal back = Signals.createSignal();
    private SubstanceLookAndFeel initialLookAndFeel;
    private boolean settingUp = false;

    public GuiConfig() {
        this.panel = new GuiConfigPanel();
        this.nav.ok.connect((Object)this, "gotOk");
        this.nav.back.connect((Object)this, "gotBack");
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.panel.settingsChanged.connect((Object)this, "gotSettingsChanged");
        this.resetButton = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/clear.png"), Internationalization.getLiteralFor((String)"RESET"), "reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiConfig.this.panel.setValues(Terminal.getLocalHost());
                GuiConfig.this.panel.updateDemo();
            }
        });
        this.resetButton.setVisible(false);
        this.nav.addRight((Component)this.resetButton);
        this.resetButton.setEnabled(false);
        if (Terminal.getAllWaiterMateTerminals().size() > 1) {
            JButton publish = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/images/allTerminal.png"), Internationalization.getLiteralFor((String)"PUBLISH_TO_ALL"), "publish");
            this.nav.addRight((Component)publish);
            publish.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiConfig.this.publishSettingsToAllTerminals();
                }
            });
        }
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.setText(Internationalization.getLiteralFor((String)"CONFIGURE_THE_DISPLAY_OPTIONS"));
    }

    public JComponent getMainArea() {
        return this.panel;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void setUp() {
        this.settingUp = true;
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (!(laf instanceof SubstanceLookAndFeel)) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"CANNOT_EDIT_CURRENT_LOOK_AND_FEEL"), (String)Internationalization.getLiteralFor((String)"UNABLE_TO_EDIT_LOOK_AND_FEEL"));
            this.back.emit();
            return;
        }
        this.initialLookAndFeel = (SubstanceLookAndFeel)laf;
        Terminal.getLocalHost().setLookAndFeelClassName(this.initialLookAndFeel.getClass().getName());
        this.panel.setValues(Terminal.getLocalHost());
        this.settingUp = false;
    }

    public void gotOk() {
        if (Dialogs.displayChoiceDialog((String)Internationalization.getLiteralFor((String)"DISPLAY_CONFIGURATION_UPDATED"), (String)("<HTML>" + Internationalization.getLiteralFor((String)"THE_DISPLAY_SETTINGS_HAVE_BEEN_UPDATED") + "<BR>" + Internationalization.getLiteralFor((String)"WAITERMATE_WILL_NEED_TO_BE_RESTARTED_FOR_FULL_CHANGES_TO_TAKE_EFFECT") + "</HTML>"), (String)Internationalization.getLiteralFor((String)"EXIT"), (String)Internationalization.getLiteralFor((String)"CANCEL"), (boolean)true)) {
            this.updateGui();
            LoginManager.exit(0);
        }
    }

    public void gotBack() {
        this.back.emit();
    }

    private void updateGui() {
        this.lafManager.updateComponent((Component)ScreenResource.getTarget(), this.panel.getLaF(), this.panel.getFontSize());
        Terminal localhost = Terminal.getLocalHost();
        localhost.setLookAndFeelClassName(this.panel.getLaF().getClass().getName());
        localhost.setGuiFontSize(this.panel.getFontSize());
        localhost.save();
        AbstractScreen.updateComponentTreeUIs();
    }

    private void publishSettingsToAllTerminals() {
        String lafClassName = this.panel.getLaF().getClass().getName();
        int fontSize = this.panel.getFontSize();
        for (Terminal terminal : Terminal.getAllWaiterMateTerminals()) {
            terminal.setGuiFontSize(fontSize);
            terminal.setLookAndFeelClassName(lafClassName);
            terminal.save();
        }
        SystemCurrentInfo.setUpdate((String)(Internationalization.getLiteralFor((String)"LOOK_AND_FEEL_CHANGED_BY") + " " + LoginManager.getInstance().getUser()));
    }

    protected void gotSettingsChanged() {
        if (!this.settingUp) {
            this.resetButton.setEnabled(true);
            this.resetButton.setVisible(true);
            this.getNavBar().getBackButton().setEnabled(false);
        }
    }
}

