/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.integration;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.integration.paypal.remote.PayPalServiceRemoteClient;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.ConditionalAdminTab;
import waitermate.gui.screens.admin.integration.IntegrationAdminPanel;
import waitermate.guikit.dialogs.Dialogs;

public class IntegrationAdmin
extends AbstractAdminScreen
implements ConditionalAdminTab {
    IntegrationAdminPanel panel = new IntegrationAdminPanel();

    public IntegrationAdmin() {
        this.panel.payPalLocationCheckIn.connect((Object)this, "gotPayPalLocationCheckIn");
    }

    @Override
    public String getCategoryName() {
        return Internationalization.getLiteralFor((String)"INTEGRATION");
    }

    @Override
    public Icon getCategoryIcon() {
        return null;
    }

    public JComponent getMainArea() {
        return this.panel;
    }

    @Override
    public boolean checkTabDisplayCondition() {
        return this.panel.hasButtons();
    }

    public void gotPayPalLocationCheckIn() {
        WebPaymentLocation location = (WebPaymentLocation)PersistenceManager.getObject(WebPaymentLocation.class, (String)Query.select(WebPaymentLocation.class).toString());
        String opposite = "open";
        String available = "closed";
        if (location.isAvailable()) {
            opposite = "closed";
            available = "open";
        }
        if (Dialogs.displayChoiceDialog((String)(location.getLabel() + "'s PayPal Availablility is set to " + available), (String)"Change Location Availability?", (String)("Change to " + opposite), (String)"Cancel", (boolean)true)) {
            PayPalServiceRemoteClient.getInstance().changeLocationAvailability(location, !location.isAvailable());
        }
    }
}

