/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.license;

import au.com.ordermate.OrderMateLog;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.JComponent;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.security.SecurityService;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMate;
import waitermate.gui.screens.admin.license.LicenseGui;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class LicenseScreen
extends AbstractScreen {
    private LicenseGui gui;
    private NavBar nav;
    public Signal complete = Signals.createSignal();

    public LicenseScreen() {
        this.gui = new LicenseGui();
        this.gui.update.connect((Object)this, "gotUpdate");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.ok.connect((Object)this.complete, "emit");
        this.nav.back.connect((Object)this.complete, "emit");
        this.nav.setText("Key Management");
    }

    public void start() {
        try {
            SecurityService securityService = PersistentLicenseManager.getInstance().getSecurityService();
            String title = "Current expiry date: " + securityService.getExpiryDate();
            this.gui.display(title);
        }
        catch (Exception e) {
            WaiterMate.LOG.error("Could not start() License state.", (Throwable)e);
            this.gui.display("");
        }
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    void gotUpdate(String key) {
        try {
            SecurityService securityService = PersistentLicenseManager.getInstance().getSecurityService();
            String result = securityService.updateKey(key);
            this.gui.setTitle("Update result: " + result);
        }
        catch (RemoteException e) {
            String s = "Unable to update Licence key";
            OrderMateLog.LOG.error(s, (Throwable)e);
        }
    }
}

