/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.paireftpos;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.linklycloud.LinklyPairRequest;
import au.com.ordermate.xmlintegration.linklycloud.LinklyPairResponse;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.misc.BusinessInfo;
import ordermate.integration.eftpos.linklycloud.LinklyIntegrationProcessor;
import ordermate.integration.eftpos.linklycloud.LinklyRequestBuilder;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.smartpay.SmartpayIntegrationProcessor;
import ordermate.integration.eftpos.smartpay.request.SmartpayRequest;
import ordermate.integration.eftpos.smartpay.response.SmartpayPairResponse;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebPairing;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.guikit.dialogs.Dialogs;

public class WMPairEftpos {
    public void start() {
        List eftposes = PersistenceManager.getObjectList(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).group().equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.TYROWEB).or().equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.SMARTPAY).or().equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.LINKLYCLOUD).endGroup().active(VirtualEftpos.class).toString());
        if (eftposes.isEmpty()) {
            Dialogs.displayOkDialog((String)"There are no integrated, pairable eftpos units", (String)"No Pairable Eftpos");
            return;
        }
        VirtualEftpos theChosenOne = null;
        if (eftposes.size() == 1) {
            theChosenOne = (VirtualEftpos)eftposes.get(0);
        } else {
            theChosenOne = (VirtualEftpos)Dialogs.displaySelectionDialog((String)"Please choose Eftpos to Pair", (List)eftposes);
            if (theChosenOne == null) {
                return;
            }
        }
        this.doPairing(theChosenOne, Terminal.getLocalHost());
    }

    private void doPairing(final VirtualEftpos eftpos, Terminal terminal) {
        if (EftposType.TYROWEB.equals((Object)eftpos.getEftposType())) {
            EftposToolkit toolkit = new EftposToolkit((GuiHandler)new WaitermateGuiHandler(), null, null);
            TyroWebContext context = new TyroWebContext(toolkit, (EftposRequest)null, eftpos.getIpAddress(), eftpos.getMerchantId(), eftpos.getTerminalId(), null, false);
            final TyroWebPairing tyroPairing = new TyroWebPairing(context, eftpos, terminal);
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    tyroPairing.performPairing();
                    eftpos.save();
                }
            };
            new Thread(runner).start();
        } else if (EftposType.SMARTPAY.equals((Object)eftpos.getEftposType())) {
            String pairingCode = Dialogs.getString((String)"Pairing Code: ");
            if (pairingCode != null && !pairingCode.trim().isEmpty()) {
                SmartpayRequest pReq = new SmartpayRequest();
                pReq.setPOSBusinessName(BusinessInfo.getInstance().getName());
                pReq.setPOSRegisterName(terminal.getName());
                pReq.setPOSVendorName("OrderMate");
                pReq.setPOSRegisterID(eftpos.getMerchantId());
                SmartpayPairResponse res = SmartpayIntegrationProcessor.getInstance().doPair(pReq, pairingCode, eftpos.getIpAddress());
                if (res.getError() != null || res == null) {
                    Dialogs.displayOkDialog((String)"Pairing Failed", (String)(res != null ? res.getError() : "Unknown Error, Check Logs"));
                } else {
                    Dialogs.displayOkDialog((String)"Pairing Successful", (String)"EFTPOS Paired");
                }
            }
        } else if (EftposType.LINKLYCLOUD.equals((Object)eftpos.getEftposType())) {
            if (eftpos.getPairUsername() == null || eftpos.getPairPassword() == null) {
                Dialogs.displayOkDialog((String)"Pairing Not Allowed", (String)"Please Confirm User + Pwd In EFTPOS Settings");
                return;
            }
            String pairingCode = Dialogs.getString((String)"Pairing Code: ");
            if (pairingCode != null && !pairingCode.trim().isEmpty()) {
                LinklyPairRequest pReq = LinklyRequestBuilder.createPairRequest((String)eftpos.getPairUsername(), (String)eftpos.getPairPassword(), (String)pairingCode);
                LinklyPairResponse res = LinklyIntegrationProcessor.getInstance().doPair(pReq, eftpos.isTesting());
                if (res != null && !StringUtils.isEmpty((String)res.getSecret())) {
                    eftpos.setPairingKeys(res.getSecret());
                    eftpos.save();
                    Dialogs.displayOkDialog((String)"Pairing Successful", (String)"EFTPOS Paired");
                } else {
                    Dialogs.displayOkDialog((String)"Pairing Failed", (String)"Error pairing pinpad to POS, please confirm config");
                }
            }
        } else {
            Dialogs.displayOkDialog((String)("The pairing for this type of eftpos cannot be performed: " + eftpos.getEftposType()), (String)"Cannot Pair");
        }
    }
}

