/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.partners;

import java.awt.Point;
import waitermate.gui.screens.admin.partners.Partner;

public class PartnerBuilder {
    private final String buttonImage;
    private String descriptionImage;
    private String description;
    private String hyperlink;
    boolean isSquare = true;
    private static final Point buttonImageSquareMax = new Point(110, 110);
    private static final Point buttonImageLongMax = new Point(165, 110);

    public PartnerBuilder(String buttonImage) {
        this.buttonImage = buttonImage;
    }

    public Partner constructPartner() {
        Partner toReturn = new Partner();
        toReturn.setImageName(this.buttonImage);
        toReturn.setImageDescriptionName(this.descriptionImage);
        toReturn.setDescription(this.description);
        toReturn.setHyperlinkDestination(this.hyperlink);
        if (this.isSquare) {
            toReturn.setMaxWidth(PartnerBuilder.buttonImageSquareMax.x);
            toReturn.setMaxHeight(PartnerBuilder.buttonImageSquareMax.y);
        } else {
            toReturn.setMaxWidth(PartnerBuilder.buttonImageLongMax.x);
            toReturn.setMaxHeight(PartnerBuilder.buttonImageLongMax.y);
        }
        return toReturn;
    }

    public PartnerBuilder setDescriptionImage(String descriptionImage) {
        this.descriptionImage = descriptionImage;
        this.description = null;
        return this;
    }

    public PartnerBuilder setDescription(String description) {
        this.description = description;
        this.descriptionImage = null;
        return this;
    }

    public PartnerBuilder setHyperlink(String link) {
        this.hyperlink = link;
        this.description = null;
        this.descriptionImage = null;
        return this;
    }

    public PartnerBuilder setImageLong() {
        this.isSquare = false;
        return this;
    }

    public PartnerBuilder setImageSquare() {
        this.isSquare = true;
        return this;
    }
}

