/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.partners;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.TextScrollPaneModel;
import waitermate.gui.screens.admin.partners.Partner;
import waitermate.gui.screens.admin.partners.PartnerBuilder;
import waitermate.guikit.ScreenResource;

public class PartnerButtonFactory {
    private static final double DIALOG_FACTOR = 0.85;
    private final GuiHandler handler;
    private final Map<String, Partner> partnerCache;

    public PartnerButtonFactory(GuiHandler handler) {
        this.handler = handler;
        this.partnerCache = new LinkedHashMap<String, Partner>();
        this.addDefaultsToCache();
    }

    private void addDefaultsToCache() {
        StringBuilder sb = new StringBuilder();
        sb.append("<br><br>bookarestaurant.com, Australian designed & developed, is an advanced restaurant booking <br>website catering for future and last-minute restaurant reservations. The search engine <br>website allows restaurateurs to advertise available tables and special offers instantly. More <br>than 2000 restaurants ranging from fine dining establishments, restaurant and hotel chains to <br>the more casual restaurants across Australia are listed with bookarestaurant.com.<br>").append("The parent company, Analytical Systems, was established in 1983 and is a world leader in <br>providing computer software solutions. The Australian developed ResPAK software was <br>first installed in 1994, providing reservation, table and guest management software to over <br>2500 restaurants in over 40 different countries around the globe. bookarestaurant.com is a <br>division of Analytical Systems Pty Ltd and is based in Melbourne, Australia.<br><br>").append("<h3><b>www.bookarestaurant.com</b></h3>");
        PartnerBuilder builder = new PartnerBuilder("/waitermate/images/partners/BookARestaurantLogo.png").setDescription(sb.toString()).setImageLong();
        this.registerPartner("bookARestaurant", builder.constructPartner());
        sb = new StringBuilder();
        sb.append("<br><br><h3><b>Website: www.myguestlist.com.au</b></h3><br>").append("<h3><b>Phone (03) 9999 2585</b></h3><br><br>").append("MyGuestlist is the world's most popular online marketing tool for the hospitality industry. <br>").append("Used globally by bars, nightclubs, restaurants, lounges and pubs, it is the most <br>").append("popular one-stop-shop for your E-Newsletters, SMS, Reservations & Bookings, Database <br>").append("management, Social Media Marketing, Ticketing, Mobile apps and Data capture. Designed <br>").append("by ex-venue owners, the tool has no lock-in contracts, minimum periods or hassles in <br>starting up.");
        builder = new PartnerBuilder("/waitermate/images/partners/MyGuesListLogo.png").setDescription(sb.toString()).setImageLong();
        this.registerPartner("myGuestlist", builder.constructPartner());
        sb = new StringBuilder();
        sb.append("<br><br>ResPAK is globally recognised as a market leader, offering powerful and intuitive features, <br>").append("whilst maintaining speed and ease. of use for both front and back of house staff. Seamlessly <br>").append("integrating Reservation & Table Management with a powerful Guest Database, ResPAK provides <br>").append("enormous improvements to operational efficiency, table yield and personalised guest service. <br><br>").append("ResPAK also provides powerful reporting and analysis capabilities, offering not only daily <br>").append("reports, but critical outlet trend analysis - providing the restaurant manager with the <br>").append("tools they need to maximise profit.<br><br>").append("With system users, and implementation experience within over 40 countries and every global <br>").append("region, combined with over 28 years of Specialised Hospitality Software experience, we offer <br>").append("you the highest degree of market knowledge, professional service & innovative and reliable <br>").append("applications which are rarely equalled by others.<br><br>").append("<h3><b>www.respak.com</b></h3>");
        builder = new PartnerBuilder("/waitermate/images/partners/ResPAKLogo.png").setDescription(sb.toString()).setImageLong();
        this.registerPartner("resPak", builder.constructPartner());
        builder = new PartnerBuilder("/waitermate/images/partners/ZwiftLogo.png").setDescriptionImage("/waitermate/images/partners/ZwiftDetails.jpg").setImageSquare();
        this.registerPartner("zwift", builder.constructPartner());
        builder = new PartnerBuilder("/waitermate/images/partners/eatNowLogo.png").setDescriptionImage("/waitermate/images/partners/eatNowDetails.jpg").setImageSquare();
        this.registerPartner("eatNow", builder.constructPartner());
        sb = new StringBuilder();
        sb.append("<br><br>The ROSS system is the centre piece of your workforce management plan. Comprising <br>").append("six cloud-based modules like payroll and time & attendance based around a core of efficient <br>").append("and effective rostering, ROSS helps any business with a pool of casual and full-time staff. ROSS <br>").append("takes into account KPI targets, awards, penalties and staff availability to empower your <br>").append("front-line managers to complete rosters on-time and on-budget so you know what your wage <br>").append("costs will be before the week starts - <a href=\"http://www.theaustralian.com.au/australian-it/it-business/diner-chain-tastes-success-in-battle-with-spreadsheets-subway/story-e6frganx-1225912074542\">saving $85,000 a year!</a> <br>").append("Your payroll staff will love ROSS too, as approved actual hours worked can be exported to many <br>").append("payroll systems <http://rosterwithross.com/payroll> . Over 15,000 staff are rostered by ROSS <br>").append("each week; visit <a href=\"http://rosterwithross.com\">rosterwithross.com</a> and try ROSS free today!");
        builder = new PartnerBuilder("/waitermate/images/partners/rossLogo.png").setDescription(sb.toString()).setImageSquare();
        this.registerPartner("ross", builder.constructPartner());
        builder = new PartnerBuilder("/waitermate/images/partners/StorePlay.png").setDescriptionImage("/waitermate/images/partners/StorePlay.png").setHyperlink("http://storeplay.com.au?c=ORDERMATE").setImageSquare();
        this.registerPartner("storeplay", builder.constructPartner());
        this.addOneShiftPartner();
    }

    public void registerPartner(String partnerKey, Partner toAddToCache) {
        this.partnerCache.put(partnerKey, toAddToCache);
    }

    public Set<String> getKeySet() {
        return this.partnerCache.keySet();
    }

    public JComponent constructPartnerButton(String partnerKey) {
        Partner partner = this.partnerCache.get(partnerKey);
        if (partner == null) {
            OrderMate.LOG.error("Could not find the Partner date for the key: " + partnerKey);
            return new JButton();
        }
        JButton button = this.constructButton(partner);
        JButton toReturn = null;
        if (partner.getHyperlinkDestination() != null) {
            this.setButtonTargetToUrl(partner, button);
            toReturn = new StandardSecurityDecorator((JComponent)button, AllPermissions.LAUNCH_EXTERNAL_WEB_LINKS);
        } else {
            this.setButtonTargetToDialog(partner, button);
            toReturn = button;
        }
        return toReturn;
    }

    private void setButtonTargetToDialog(Partner partner, JButton button) {
        final JPanel panel = this.constructButtonPanel(partner);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartnerButtonFactory.this.handler.displayOkDialog((JComponent)panel, "");
            }
        });
    }

    private void setButtonTargetToUrl(Partner partner, JButton button) {
        if (!Desktop.isDesktopSupported()) {
            OrderMate.LOG.warn("Desktop class is not supported by this OS, therefore a hyperlink that launches the browser cannot be constructed.");
            return;
        }
        final String url = partner.getHyperlinkDestination();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Failed to launch URL in browser; this action may not be supported.", (Throwable)ex);
                }
            }
        });
    }

    private JButton constructButton(Partner partner) {
        ImageIcon image = IconLoader.get((String)partner.getImageName());
        ImageHelper ih = new ImageHelper();
        JButton button = partner.getMaxWidth() > 0 && partner.getMaxHeight() > 0 ? new JButton(new ImageIcon(ih.fitImageTo(image.getImage(), partner.getMaxWidth(), partner.getMaxHeight()))) : new JButton(image);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    public ImageIcon constructImageDescription(String desc) {
        ImageIcon imageDescription = null;
        try {
            imageDescription = IconLoader.get((String)desc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Dimension screen = ScreenResource.getTarget().getSize();
        if (screen != null && imageDescription != null && ((double)imageDescription.getIconWidth() > screen.getWidth() * 0.85 || (double)imageDescription.getIconHeight() > screen.getHeight() * 0.85)) {
            Dimension dim = new Dimension((int)((double)screen.width * 0.85), (int)((double)screen.height * 0.85));
            ImageHelper helper = new ImageHelper();
            imageDescription.setImage(helper.fitImageTo(imageDescription.getImage(), dim.width, dim.height));
        }
        return imageDescription;
    }

    private JPanel constructButtonPanel(Partner partner) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        ImageIcon imageDescription = this.constructImageDescription(partner.getImageDescriptionName());
        if (imageDescription == null) {
            ImageIcon image = IconLoader.get((String)partner.getImageName());
            ImageHelper ih = new ImageHelper();
            Image img = image.getImage();
            img = ih.fitImageTo(img, 400, 100);
            panel = this.createPartnersTextScrollPanePanel(partner.getDescription());
            panel.add((Component)new JLabel(new ImageIcon(img)), "North");
        } else {
            panel.add((Component)new JLabel(imageDescription), "Center");
        }
        return panel;
    }

    private JPanel createPartnersTextScrollPanePanel(String toDisplay) {
        JPanel newPanel = new JPanel(new BorderLayout());
        TextScrollPaneModel textModel = new TextScrollPaneModel(14);
        String[] descArray = toDisplay.split("<br>");
        for (int i = 0; i < descArray.length; ++i) {
            textModel.addLine("<HTML>" + descArray[i] + "</HTML>");
        }
        CustomScrollPane scrollPane = new CustomScrollPane((CustomScrollPaneModel)textModel);
        scrollPane.setPreferredSize(new Dimension(550, 300));
        newPanel.add((Component)scrollPane, "Center");
        return newPanel;
    }

    private void addOneShiftPartner() {
        PartnerBuilder builder = new PartnerBuilder("/waitermate/images/partners/OneShiftLogo.jpg").setHyperlink("http://www.oneshift.com.au/ordermate").setImageLong();
        this.registerPartner("oneShift", builder.constructPartner());
    }
}

