/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.printer.printerredirection;

import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.printer.printerredirection.RedirectPrintersNav;
import waitermate.gui.screens.admin.printer.printerredirection.RedirectPrintersPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class RedirectPrinters
extends AbstractScreen {
    private RedirectPrintersPanel gui;
    private RedirectPrintersNav nav;
    private List<VirtualPrinter> virtualPrinters;
    private List<PhysicalPrintDevice> printDevices;
    public final Signal done = Signals.createSignal();

    public RedirectPrinters() {
        this.gui = new RedirectPrintersPanel();
        this.nav = new RedirectPrintersNav();
        this.nav.back.connect((Object)this, "gotBack");
        this.nav.ok.connect((Object)this, "gotOK");
        this.nav.clear.connect((Object)this, "gotClear");
    }

    public void start() {
        this.virtualPrinters = VirtualPrinter.getAllPrinters();
        this.printDevices = PhysicalPrintDevice.getAllActivePrintDevices();
        this.gui.setup(this.virtualPrinters, this.printDevices);
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotClear() {
        this.gui.reset(this.virtualPrinters);
    }

    public void gotOK() {
        Map<VirtualPrinter, PhysicalPrintDevice> printerMap = this.gui.getPrinterMap();
        for (VirtualPrinter vPrinter : this.virtualPrinters) {
            PhysicalPrintDevice pPrinter = printerMap.get(vPrinter);
            if (pPrinter == vPrinter.getPrintDevice()) continue;
            vPrinter.setPrintDevice(pPrinter);
            vPrinter.save();
            SystemCurrentInfo.setUpdate((String)"Printer Changed");
        }
        this.done.emit();
    }

    public void gotBack() {
        this.gotClear();
        this.done.emit();
    }
}

