/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.printer.reprintdockets;

import java.io.IOException;
import javax.swing.JComponent;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMate;
import waitermate.gui.screens.admin.printer.reprintdockets.DocketSearchNavBar;
import waitermate.gui.screens.admin.printer.reprintdockets.DocketSearchPanel;
import waitermate.gui.screens.admin.printer.reprintdockets.ReprintDocket;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class DocketSearch
extends AbstractScreen {
    DocketSearchNavBar nav;
    DocketSearchPanel gui;
    ReprintDocket viewState;
    public final Signal back = Signals.createSignal();

    public DocketSearch() {
        this.gui = new DocketSearchPanel();
        this.viewState = new ReprintDocket();
        this.viewState.done.connect((Object)this, "start");
        this.nav = new DocketSearchNavBar();
        this.nav.back.connect((Object)this, "gotBack");
        this.nav.print.connect((Object)this, "gotPrint");
        this.nav.view.connect((Object)this, "gotView");
    }

    public void start() {
        this.gui = new DocketSearchPanel();
        this.gui.start();
        this.display();
    }

    public void gotBack() {
        this.back.emit();
    }

    public void gotPrint() {
        String message = Internationalization.getLiteralFor((String)"ARE_YOU_SURE_YOU_WANT_TO_REPRINT_THESE_PREP_DOCKETS");
        boolean result = Dialogs.displayChoiceDialog((String)message, (String)Internationalization.getLiteralFor((String)"REPRINT_QUESTIONMARK"), (boolean)true);
        if (result) {
            for (SalesAccountDocket docket : this.gui.getSelectedDockets()) {
                try {
                    DocketProcessor.rePrintDocket((AbstractDocket)docket);
                }
                catch (IOException e) {
                    WaiterMate.LOG.error("An error occurred trying to reprint a docket ");
                    Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"AN_ERROR_OCCURED_AND_THE_DOCKET_COULD_NOT_BE_PRINTED"), (String)Internationalization.getLiteralFor((String)"ERROR_PRINTING"));
                }
            }
        }
        this.back.emit();
    }

    public void gotView() {
        this.viewState.start(this.gui.getSelectedDockets());
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }
}

