/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.printer.reprintdockets;

import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.sales.Account;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.internationalization.Internationalization;
import ordermate.maps.docket.SalesAccountDocketMap;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.printer.reprintdockets.ReprintDocketNav;
import waitermate.gui.screens.admin.printer.reprintdockets.ReprintDocketPanel;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class ReprintDocket
extends AbstractScreen {
    ReprintDocketNav nav;
    ReprintDocketPanel gui;
    Account theAccount;
    public final Signal done = Signals.createSignal();

    public ReprintDocket() {
        this.nav = new ReprintDocketNav();
        this.gui = new ReprintDocketPanel();
        this.nav.back.connect((Object)this, "gotBack");
        this.nav.print.connect((Object)this, "gotPrint");
    }

    public void start(Account account) {
        this.theAccount = account;
        List dockets = SalesAccountDocketMap.getDocketsForAccount((Account)account);
        this.gui.setup(dockets);
        this.display();
    }

    public void start(List dockets) {
        this.gui.setup(dockets);
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotPrint() {
        boolean result = false;
        if (!this.gui.getDocketsToPrint().isEmpty()) {
            String message = Internationalization.getLiteralFor((String)"ARE_YOU_SURE_YOU_WANT_TO_REPRINT_THESE_PREP_DOCKETS");
            result = Dialogs.displayChoiceDialog((String)message, (String)Internationalization.getLiteralFor((String)"REPRINT_QUESTIONMARK"), (boolean)true);
        }
        if (result) {
            for (SalesAccountDocket docket : this.gui.getDocketsToPrint()) {
                try {
                    DocketProcessor.rePrintDocket((AbstractDocket)docket);
                }
                catch (IOException e) {
                    WaitermateSaveAccount.getInstance().handlePrinterError(e, "account " + this.theAccount.getLabel());
                }
            }
        }
        this.done.emit();
    }

    public void gotBack() {
        this.done.emit();
    }
}

