/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.printer.reprintdockets;

import au.com.ordermate.persistence.Displayable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DisplayableToggleRenderer;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ReprintDocketPanel
extends JPanel {
    private RendererScrollPaneModel model;
    private DisplayableToggleRenderer renderer;
    private CustomScrollPane scrollPane;
    public final Signal print = Signals.createSignal(Displayable.class, (String)"add");

    public ReprintDocketPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.renderer = new DisplayableToggleRenderer();
        this.model = new RendererScrollPaneModel((Renderer)this.renderer, 3, 2);
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.scrollPane.setEmptyMessage(Internationalization.getLiteralFor((String)"NO_PREP_DOCKETS_HAVE_BEEN_PRINTED_FOR_THIS_ACCOUNT"));
        JPanel docketPanel = new JPanel(new BorderLayout());
        docketPanel.setBorder(new TitledBorder(null, Internationalization.getLiteralFor((String)"SELECT_THE_PREP_DOCKETS_TO_REPRINT") + ": ", 4, 2, OrderMateTheme.getMediumFont()));
        docketPanel.add((Component)this.scrollPane, "Center");
        this.add((Component)docketPanel, "Center");
        this.renderer.selected.connect((Object)this, "gotSelected");
    }

    public void setup(List dockets) {
        this.model.removeAllObjects();
        this.renderer.clearSelection();
        this.model.setObjects(dockets);
    }

    public void gotSelected(Displayable docket) {
        this.scrollPane.displayPage(this.scrollPane.getCurrentPage());
    }

    public List getDocketsToPrint() {
        return this.renderer.getSelectedObjects();
    }

    public int getNumDockets() {
        return this.model.getObjects().size();
    }
}

