/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.Permission;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DateSelector
extends JPanel
implements ActionListener {
    private Permission dateSelectorPermission;
    private Calendar calendar = Calendar.getInstance();
    private JButton dayUp;
    private JButton dayDown;
    private JButton weekUp;
    private JButton weekDown;
    private JButton monthUp;
    private JButton monthDown;
    private JButton yearUp;
    private JButton yearDown;
    private JButton todayButton;
    private JPanel buttonHolder;
    private JLabel dateLabel;
    private DateFormat format = new SimpleDateFormat("EEE, MMM d yyyy");
    public Signal<Date, ?, ?, ?, ?> updated = Signals.createSignal(Date.class, (String)"newDate");

    public DateSelector(Permission permission) {
        super(new BorderLayout());
        this.dateSelectorPermission = permission;
        DateTimeUtils.clearTimePart((Calendar)this.calendar);
        this.setupComponents();
        this.updateDisplay();
    }

    private void setupComponents() {
        JPanel topHolder = new JPanel(new FlowLayout(1, 10, 20));
        this.dateLabel = new JLabel();
        topHolder.add(this.dateLabel);
        this.add((Component)topHolder, "North");
        this.dateLabel.setFont(OrderMateTheme.getLargeFont());
        this.dateLabel.setAlignmentX(0.5f);
        this.buttonHolder = new JPanel(new GridLayout(5, 3, 10, 10));
        this.dayDown = this.makeButton(false);
        this.weekDown = this.makeButton(false);
        this.monthDown = this.makeButton(false);
        this.yearDown = this.makeButton(false);
        this.dayUp = this.makeButton(true);
        this.weekUp = this.makeButton(true);
        this.monthUp = this.makeButton(true);
        this.yearUp = this.makeButton(true);
        this.todayButton = this.makeButton(true);
        this.todayButton.setIcon(IconLoader.get((String)"/ordermate/images/clock16.png"));
        this.todayButton.setText("Today");
        this.todayButton.setName("todayButton");
        this.addButtonWithSecurity(this.dateSelectorPermission);
        this.buttonHolder.add(Box.createGlue());
        this.buttonHolder.add(this.todayButton);
        this.buttonHolder.add(Box.createGlue());
        this.add((Component)this.buttonHolder, "Center");
        this.add(Box.createHorizontalStrut(300), "South");
    }

    private void addButtonWithSecurity(Permission permission) {
        StandardSecurityDecorator dayDownSec = new StandardSecurityDecorator((JComponent)this.dayDown, permission);
        StandardSecurityDecorator dayUpSec = new StandardSecurityDecorator((JComponent)this.dayUp, permission);
        StandardSecurityDecorator weekDownSec = new StandardSecurityDecorator((JComponent)this.weekDown, permission);
        StandardSecurityDecorator weekUpSec = new StandardSecurityDecorator((JComponent)this.weekUp, permission);
        StandardSecurityDecorator monthDownSec = new StandardSecurityDecorator((JComponent)this.monthDown, permission);
        StandardSecurityDecorator monthUpSec = new StandardSecurityDecorator((JComponent)this.monthUp, permission);
        StandardSecurityDecorator yearDownSec = new StandardSecurityDecorator((JComponent)this.yearDown, permission);
        StandardSecurityDecorator yearUpSec = new StandardSecurityDecorator((JComponent)this.yearUp, permission);
        this.buttonHolder.add((Component)dayDownSec);
        this.buttonHolder.add(this.makeLabel("Day"));
        this.buttonHolder.add((Component)dayUpSec);
        this.buttonHolder.add((Component)weekDownSec);
        this.buttonHolder.add(this.makeLabel("Week"));
        this.buttonHolder.add((Component)weekUpSec);
        this.buttonHolder.add((Component)monthDownSec);
        this.buttonHolder.add(this.makeLabel("Month"));
        this.buttonHolder.add((Component)monthUpSec);
        this.buttonHolder.add((Component)yearDownSec);
        this.buttonHolder.add(this.makeLabel("Year"));
        this.buttonHolder.add((Component)yearUpSec);
    }

    private JLabel makeLabel(String value) {
        JLabel label = new JLabel(value);
        label.setFont(OrderMateTheme.getMediumFont());
        label.setHorizontalAlignment(0);
        return label;
    }

    private JButton makeButton(boolean up) {
        JButton button = new JButton();
        OrderMateTheme.setupTransparentButton((AbstractButton)button);
        if (up) {
            button.setIcon(IconLoader.get((String)"/waitermate/images/rightarrow.png"));
        } else {
            button.setIcon(IconLoader.get((String)"/waitermate/images/leftarrow.png"));
        }
        button.setFont(OrderMateTheme.getMediumFont());
        button.addActionListener(this);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.dayDown) {
            this.calendar.add(5, -1);
        } else if (source == this.dayUp) {
            this.calendar.add(5, 1);
        } else if (source == this.weekDown) {
            this.calendar.add(3, -1);
        } else if (source == this.weekUp) {
            this.calendar.add(3, 1);
        } else if (source == this.monthDown) {
            this.calendar.add(2, -1);
        } else if (source == this.monthUp) {
            this.calendar.add(2, 1);
        } else if (source == this.yearDown) {
            this.calendar.add(1, -1);
        } else if (source == this.yearUp) {
            this.calendar.add(1, 1);
        } else if (source == this.todayButton) {
            this.calendar.setTime(new Date());
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.clampDate();
        Date time = this.calendar.getTime();
        this.dateLabel.setText(this.format.format(time));
        this.updated.emit((Object)time);
    }

    private void clampDate() {
        TradingDay last = TradingDay.getCurrentTradingDay();
        if (this.calendar.getTime().after(last.getDate())) {
            this.calendar.setTime(last.getDate());
        }
    }

    public void setSelectedDate(Date value) {
        if (value != null) {
            this.calendar.setTime(value);
            this.updateDisplay();
        }
    }
}

