/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.Shift;
import ordermate.database.users.Permission;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.reports.DateSelector;

class DayShiftSelectionPanel
extends JPanel
implements ActionListener {
    private Permission permission;
    private DateSelector dateSelector;
    private JPanel shiftPanel;
    private ButtonGroup shiftGroup;
    private List<JRadioButton> shiftButtons = new ArrayList<JRadioButton>();
    private List<Shift> shifts;
    public Signal<Shift, ?, ?, ?, ?> shiftSelected = Signals.createSignal(Shift.class, (String)"theShift");

    DayShiftSelectionPanel(Permission shiftsPermission, Permission dateSelectorPermission) {
        super(new BorderLayout());
        this.permission = shiftsPermission;
        TitledBorder border = OrderMateTheme.makeTitledBorder((String)"Date & Shift");
        this.shiftGroup = new ButtonGroup();
        this.setBorder(border);
        this.setupDateSelector(dateSelectorPermission);
        this.setupShiftSelector();
        this.setDate(new Date());
    }

    private void setupDateSelector(Permission dateSelectorPermission) {
        this.dateSelector = new DateSelector(dateSelectorPermission);
        this.add((Component)this.dateSelector, "North");
        this.dateSelector.updated.connect((Object)this, "setDate");
    }

    private void setupShiftSelector() {
        this.shiftPanel = new JPanel();
        this.shiftPanel.setLayout(new BoxLayout(this.shiftPanel, 1));
        this.shiftPanel.add(Box.createVerticalStrut(40));
        this.add((Component)this.shiftPanel, "Center");
    }

    public void setDate(Date date) {
        this.shifts = Shift.getShiftsForDate((Date)date);
        if (this.shiftButtons.size() < this.shifts.size()) {
            for (int i = 0; i < this.shifts.size() - this.shiftButtons.size(); ++i) {
                JRadioButton button = this.makeRadioButton();
                StandardSecurityDecorator shiftButtonSec = new StandardSecurityDecorator((JComponent)button, this.permission);
                this.shiftButtons.add(button);
                this.shiftGroup.add(button);
                this.shiftPanel.add((Component)shiftButtonSec);
            }
            this.shiftButtons.get(0).setSelected(true);
        }
        int selection = 0;
        for (int i = 0; i < this.shiftButtons.size(); ++i) {
            if (i < this.shifts.size()) {
                this.shiftButtons.get(i).setText(this.shifts.get(i).getLabel());
                this.shiftButtons.get(i).setVisible(true);
                if (!this.shiftButtons.get(i).isSelected()) continue;
                selection = i;
                continue;
            }
            this.shiftButtons.get(i).setVisible(false);
        }
        if (selection < this.shifts.size()) {
            this.shiftButtons.get(selection).setSelected(true);
            this.shiftSelected.emit((Object)this.shifts.get(selection));
        } else {
            this.shiftSelected.emit(null);
        }
    }

    private JRadioButton makeRadioButton() {
        JRadioButton radioButton = new JRadioButton();
        OrderMateTheme.setupTransparentButton((AbstractButton)radioButton);
        radioButton.addActionListener(this);
        radioButton.setSelectedIcon(IconLoader.get((String)"/waitermate/images/plus.png"));
        radioButton.setIcon(IconLoader.get((String)"/waitermate/images/minus.png"));
        return radioButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        for (int i = 0; i < this.shiftButtons.size(); ++i) {
            if (source != this.shiftButtons.get(i)) continue;
            this.shiftSelected.emit((Object)this.shifts.get(i));
        }
    }

    public Shift getSelectedShift() {
        for (int i = 0; i < this.shiftButtons.size(); ++i) {
            if (!this.shiftButtons.get(i).isSelected() || !this.shiftButtons.get(i).isVisible()) continue;
            return this.shifts.get(i);
        }
        return null;
    }

    public void setSelectedShift(Shift theShift) {
        if (theShift != null) {
            this.dateSelector.setSelectedDate(theShift.getTradingDay().getDate());
            for (int i = 0; i < this.shifts.size(); ++i) {
                if (!theShift.equals((Object)this.shifts.get(i)) || i >= this.shiftButtons.size() || this.shiftButtons.get(i) == null) continue;
                this.shiftButtons.get(i).setSelected(true);
            }
        }
    }
}

