/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import ordermate.database.finance.Shift;
import ordermate.database.users.AllPermissions;
import ordermate.docketprocessor.WaitermateReportType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.reports.DayShiftSelectionPanel;
import waitermate.gui.screens.admin.reports.WaitermateReportSelectionPanel;

public class WaitermateReportPanel
extends JPanel {
    private DayShiftSelectionPanel shiftSelector;
    private WaitermateReportSelectionPanel reportSelection;
    public final Signal<WaitermateReportType, ?, ?, ?, ?> reportPressed;
    public final Signal<Shift, ?, ?, ?, ?> shiftSelected = Signals.createSignal(Shift.class, (String)"theShift");

    public WaitermateReportPanel() {
        super(new BorderLayout());
        this.shiftSelector = new DayShiftSelectionPanel(AllPermissions.VIEW_PREVIOUS_SHIFTS, AllPermissions.VIEW_PREVIOUS_DAY_TAKINGS);
        this.shiftSelector.setName("shift-selector");
        this.reportSelection = new WaitermateReportSelectionPanel();
        this.add((Component)this.shiftSelector, "West");
        this.add((Component)this.reportSelection, "Center");
        this.reportPressed = this.reportSelection.reportPressed;
        this.shiftSelector.shiftSelected.connect((Object)this, "gotShift");
    }

    public List<WaitermateReportType> getSelectedReports() {
        return this.reportSelection.getSelectedReports();
    }

    public Shift getSelectedShift() {
        return this.shiftSelector.getSelectedShift();
    }

    public void setSelectedShift(Shift theShift) {
        this.shiftSelector.setSelectedShift(theShift);
    }

    void gotShift(Shift value) {
        this.reportSelection.setEnabled(value != null);
        this.shiftSelected.emit((Object)value);
    }
}

