/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.CashDrawerTakingsSummary;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.finance.reports.SalesSummary;
import ordermate.database.finance.reports.TakingsReportHeader;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.kts.KTSDocketDataSummary;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.docketprocessor.WaitermateReportType;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.TextScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.screens.admin.Admin;
import waitermate.gui.screens.admin.daily.DailyAdmin;
import waitermate.gui.screens.admin.reports.WaitermateReportPanel;
import waitermate.gui.screens.admin.reports.impl.AccountsWaitermateReport;
import waitermate.gui.screens.admin.reports.impl.AllCashdrawersWaitermateReport;
import waitermate.gui.screens.admin.reports.impl.KTSWaitermateReport;
import waitermate.gui.screens.admin.reports.impl.LabourWaitermateReport;
import waitermate.gui.screens.admin.reports.impl.SalesWaitermateReport;
import waitermate.gui.screens.admin.reports.impl.TerminalTakingsWaitermateReport;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.SignalEmittingTimer;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.OnePressPopupWindow;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;

public class WaitermateReports
extends AbstractScreen {
    private static final int NUM_LINES = 22;
    public final Signal done = Signals.createSignal();
    private final WaitermateReportPanel gui;
    private final NavBar nav;
    private RestaurantTakingsSummary currentTakingsSummary;
    private List<CashDrawerTakingsSummary> currentCashdrawerSummaries;
    private WaitermateReportType miniReportType;
    private SignalEmittingTimer backTimer;
    public final Signal back = Signals.createSignal();
    public final Signal logout = Signals.createSignal();
    private DailyAdmin dailyAdmin;
    private PopupWindow popupReport;

    public WaitermateReports() {
        this.gui = new WaitermateReportPanel();
        this.gui.shiftSelected.connect((Object)this, "shiftChanged");
        this.gui.reportPressed.connect((Object)this, "reportSelected");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.getPrintButton().setText("Print Selected");
        this.nav.addRight((Component)this.nav.getPrintButton());
        this.nav.back.connect((Object)this.done, "emit");
        this.nav.ok.connect((Object)this.done, "emit");
        this.nav.print.connect((Object)this, "gotPrintSelected");
        this.back.connect((Object)this, "back");
    }

    public WaitermateReports(DailyAdmin dailyAdmin) {
        this();
        this.dailyAdmin = dailyAdmin;
        this.logout.connect((Object)dailyAdmin.logout, "emit");
    }

    private void back() {
        this.done.emit();
        Admin adminScreen = this.dailyAdmin.getAdminCategoryPanel().getAdminScreen();
        adminScreen.getNavBar().back.emit();
    }

    public void display() {
        super.display();
        this.resetBackTimer();
    }

    private void resetBackTimer() {
        int FIFTEEN_SEC = 15;
        int timeout = Terminal.getLocalHost().getBackToIdleTimeout();
        if (timeout <= 0) {
            timeout = 900;
        }
        if (this.backTimer != null) {
            this.backTimer.stop();
        }
        this.backTimer = new SignalEmittingTimer(timeout, 15, this, this.back, Internationalization.getLiteralFor((String)"THE_SYSTEM_WILL_AUTOMATICALLY_LEAVE_THIS_SCREEN"), "Back"){

            protected void doAction(int countDownInSec, Signal toEmit, String message, String positiveAction) {
                if (WaitermateReports.this.popupReport != null) {
                    WaitermateReports.this.popupReport.stop();
                }
                super.doAction(countDownInSec, toEmit, message, positiveAction);
            }
        };
    }

    public void tearDown() {
        if (this.backTimer != null) {
            this.backTimer.stop();
            this.backTimer = null;
        }
        super.tearDown();
    }

    public void start(Shift theShift) {
        this.gui.setSelectedShift(theShift);
        this.display();
    }

    public void shiftChanged(Shift theShift) {
        this.currentTakingsSummary = null;
        this.currentCashdrawerSummaries = null;
        this.nav.getPrintButton().setEnabled(theShift != null);
    }

    private void calculateCashdrawerSummary() {
        Terminal localhost = Terminal.getLocalHost();
        List cashdrawers = localhost.getAvailableLogicallyConnectedCashDrawers();
        this.currentCashdrawerSummaries = new ArrayList<CashDrawerTakingsSummary>(cashdrawers.size());
        for (CashDrawer cashdrawer : cashdrawers) {
            CashDrawerTakingsSummary takings = CashDrawerTakingsSummary.getSummary((CashDrawer)cashdrawer, (Shift)this.gui.getSelectedShift());
            this.currentCashdrawerSummaries.add(takings);
        }
    }

    private void calculateTakingsSummary() {
        Shift currentShift = this.gui.getSelectedShift();
        this.currentTakingsSummary = RestaurantTakingsSummary.getSummary((Shift)currentShift);
        AbstractTask task = new AbstractTask(){

            public String getName() {
                return "Calculating Report...";
            }

            protected void performTask() throws Exception {
                WaitermateReports.this.currentTakingsSummary = (RestaurantTakingsSummary)PersistenceManager.getServerConnection().runSync((Executable)new RestaurantTakingsSummary.RemoteTask(WaitermateReports.this.currentTakingsSummary));
            }

            protected int getTotalSubTasks() {
                return 0;
            }
        };
        ProgressDialog.doProgressDialog((Task)task);
        this.nav.setText(currentShift == null ? "No Shift" : currentShift.getLabel());
        TerminalEventLog.logTakingsView((User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost());
        if (this.currentTakingsSummary.getNumAccountsTotal(true) > 0) {
            Dialogs.displayOkDialog((String)"You should ensure that all accounts are closed before change of day.", (String)("There are " + this.currentTakingsSummary.getNumAccountsTotal(true) + " opened account(s)"));
        }
    }

    public void gotPrintSelected() {
        List<WaitermateReportType> reports = this.gui.getSelectedReports();
        if (reports.size() == 0) {
            Dialogs.displayOkDialog((String)"Please choose at least one report.", (String)"No Reports Selected");
            return;
        }
        for (WaitermateReportType reportType : reports) {
            this.printReport(reportType);
        }
    }

    public void gotPrintMiniReport() {
        if (this.miniReportType != null) {
            this.printReport(this.miniReportType);
        }
    }

    public void reportSelected(WaitermateReportType type) {
        List<String> data = this.getDataFor(type);
        if (data != null) {
            this.viewGenericWaitermateReport(type, data);
        }
    }

    private void viewGenericWaitermateReport(WaitermateReportType type, List<String> reportData) {
        TextScrollPaneModel model = new TextScrollPaneModel(22);
        model.setFont(new Font("Monospaced", 0, 12));
        model.setLines(reportData);
        NavBar bar = new NavBar();
        bar.addLeft((Component)bar.getPrintButton());
        bar.getPrintButton().setText("Print Report");
        bar.addRight((Component)bar.getOkButton());
        bar.setText("  " + type.getLabel() + " Report  ");
        bar.print.connect((Object)this, "gotPrintMiniReport");
        this.miniReportType = type;
        this.popupReport = new PopupWindow(bar);
        this.popupReport.setPreferredSize(new Dimension(400, 600));
        this.popupReport.setComponent((JComponent)new CustomScrollPane((CustomScrollPaneModel)model));
        this.popupReport.start();
        bar.print.disconnect((Object)this);
        this.miniReportType = null;
    }

    private List<String> getDataFor(WaitermateReportType type) {
        List<String> data = null;
        if (WaitermateReportType.Takings.equals((Object)type)) {
            data = this.doTerminalTakings();
        } else if (WaitermateReportType.AllCashdrawers.equals((Object)type)) {
            data = this.doAllCashdrawerTakings();
        } else if (WaitermateReportType.AccountSales.equals((Object)type)) {
            data = this.doAccountSales();
        } else if (WaitermateReportType.Sales.equals((Object)type)) {
            data = this.doSales();
        } else if (WaitermateReportType.Labour.equals((Object)type)) {
            data = this.doLabour();
        } else if (WaitermateReportType.KTS.equals((Object)type)) {
            data = this.doKTS();
        } else {
            throw new IllegalArgumentException("Unknown Waitermate Report Type:" + type);
        }
        return data;
    }

    private List<String> doAccountSales() {
        AccountsWaitermateReport report = new AccountsWaitermateReport(this.getCurrentTakings());
        report.performReport();
        return report.getStringData();
    }

    private List<String> doTerminalTakings() {
        ArrayList<Object> params = new ArrayList<Object>();
        this.setupParamsForType(params, WaitermateReportType.Takings);
        TerminalTakingsWaitermateReport terminalTakingsReport = new TerminalTakingsWaitermateReport(params);
        terminalTakingsReport.performReport();
        return terminalTakingsReport.getStringData();
    }

    private List<String> doAllCashdrawerTakings() {
        AllCashdrawersWaitermateReport allCashdrawerReport = new AllCashdrawersWaitermateReport(this.getCurrentTakings());
        allCashdrawerReport.performReport();
        return allCashdrawerReport.getStringData();
    }

    private List<String> doSales() {
        SalesWaitermateReport salesReport = new SalesWaitermateReport(this.gui.getSelectedShift());
        salesReport.performReport();
        return salesReport.getStringData();
    }

    private List<String> doLabour() {
        LabourWaitermateReport report = new LabourWaitermateReport(this.getCurrentTakings());
        report.performReport();
        return report.getStringData();
    }

    private List<String> doKTS() {
        KTSWaitermateReport report = new KTSWaitermateReport(this.gui.getSelectedShift());
        report.performReport();
        return report.getStringData();
    }

    private TakingsReportHeader getReportHeader() {
        Shift shift = this.gui.getSelectedShift();
        NumberReport report = (NumberReport)PersistenceManager.getObject(NumberReport.class, (String)Query.count(Account.class, (String)"value").equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).equals(Account.Properties.SHIFT, (Object)shift).toString());
        return new TakingsReportHeader(shift, report.intValue(), 0);
    }

    private RestaurantTakingsSummary getCurrentTakings() {
        if (this.currentTakingsSummary == null) {
            this.calculateTakingsSummary();
        }
        return this.currentTakingsSummary;
    }

    private List<CashDrawerTakingsSummary> getCurrentCashdrawerSummaries() {
        this.currentCashdrawerSummaries = null;
        if (this.currentCashdrawerSummaries == null) {
            this.calculateCashdrawerSummary();
        }
        return this.currentCashdrawerSummaries;
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    private void printSales() {
        SalesSummary summary = SalesSummary.getSummary((Shift)this.gui.getSelectedShift());
        ProgressDialog.doProgressDialog((Task)summary.getCalculateTask());
        Terminal thisTerminal = Terminal.getLocalHost();
        List printers = thisTerminal.getAvailableReceiptPrinters();
        try {
            DocketProcessor.printSalesDocket((User)LoginManager.getInstance().getUser(), (Terminal)thisTerminal, (Collection)printers, (SalesSummary)summary);
        }
        catch (IOException e) {
            WaiterMate.LOG.error("Couldn't print takings docket", (Throwable)e);
        }
    }

    private void printTakings() {
        Terminal thisTerminal = Terminal.getLocalHost();
        List printers = thisTerminal.getAvailableReceiptPrinters();
        try {
            DocketProcessor.printTakingsDocket((User)LoginManager.getInstance().getUser(), (Terminal)thisTerminal, (RestaurantTakingsSummary)this.getCurrentTakings(), this.getCurrentCashdrawerSummaries(), (Collection)printers);
        }
        catch (IOException e) {
            WaiterMate.LOG.error("Couldn't print takings docket", (Throwable)e);
        }
    }

    private void printReport(WaitermateReportType type) {
        Terminal terminal = Terminal.getLocalHost();
        ArrayList<VirtualPrinter> printers = terminal.getAvailableReceiptPrinters();
        if (printers.size() > 1) {
            List buttons = AbstractScrollPaneModel.constructButtons((Collection)printers);
            OnePressPopupWindow printerDialog = new OnePressPopupWindow("Select Receipt Printer", (Collection)buttons, 1, 3, false);
            CustomButton selectedButton = (CustomButton)printerDialog.start();
            printers = new ArrayList<VirtualPrinter>();
            printers.add((VirtualPrinter)selectedButton.getData());
        }
        ArrayList<Object> params = new ArrayList<Object>();
        this.setupParamsForType(params, type);
        try {
            DocketProcessor.printWaitermateReport((EventContext)LoginManager.getEventContext(), (WaitermateReportType)type, (Collection)printers, params);
        }
        catch (IOException e) {
            WaiterMate.LOG.error("Couldn't print waitermate report docket", (Throwable)e);
        }
    }

    private void setupParamsForType(List<Object> params, WaitermateReportType type) {
        if (WaitermateReportType.Takings.equals((Object)type)) {
            params.add(this.getCurrentTakings());
            params.add(this.getCurrentCashdrawerSummaries());
            params.add(Terminal.getLocalHost());
            params.add(this.getReportHeader());
        } else if (WaitermateReportType.AllCashdrawers.equals((Object)type)) {
            RestaurantTakingsSummary summary = this.getCurrentTakings();
            summary.groupAllCustomSurcharges();
            params.add(summary);
        } else if (WaitermateReportType.Sales.equals((Object)type)) {
            SalesSummary summary = SalesSummary.getSummary((Shift)this.gui.getSelectedShift());
            ProgressDialog.doProgressDialog((Task)summary.getCalculateTask());
            params.add(summary);
        } else if (WaitermateReportType.AccountSales.equals((Object)type)) {
            params.add(this.getCurrentTakings());
        } else if (WaitermateReportType.Labour.equals((Object)type)) {
            params.add(this.getCurrentTakings());
        } else if (WaitermateReportType.KTS.equals((Object)type)) {
            Shift shift = this.gui.getSelectedShift();
            KTSDocketDataSummary summary = (KTSDocketDataSummary)PersistenceManager.getObject(KTSDocketDataSummary.class, (String)KTSDocketDataSummary.getSummaryQuery((Date)shift.getTradingDay().getOpenDateTime(), (Date)shift.getTradingDay().getCloseDateTime(), null).toString(), null);
            params.add(summary);
            params.add(shift);
        }
    }
}

