/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports.impl;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.physical.kts.KTSDocketDataSummary;
import ordermate.database.misc.BusinessInfo;
import waitermate.gui.screens.admin.reports.impl.AbstractWaitermateReport;

public class KTSWaitermateReport
extends AbstractWaitermateReport {
    private KTSDocketDataSummary summary = null;
    private Shift shift;

    public KTSWaitermateReport(Shift theShift) {
        this.shift = theShift;
    }

    @Override
    public void performReport() {
        this.clear();
        this.add(BusinessInfo.getInstance().getName());
        this.add("");
        this.add("Shift: " + new SimpleDateFormat("E MMM d, yyyy").format(this.shift.getTradingDay().getDate()));
        this.add("Trading day commenced : " + DateTimeUtils.getSimpleTimeFormat().format(this.shift.getTradingDay().getTime()));
        this.add("");
        this.summary = (KTSDocketDataSummary)PersistenceManager.getObject(KTSDocketDataSummary.class, (String)KTSDocketDataSummary.getSummaryQuery((Date)this.shift.getTradingDay().getOpenDateTime(), (Date)this.shift.getTradingDay().getCloseDateTime(), null).toString(), null);
        this.add("Highest Total Time: " + DateTimeUtils.toMinutesSeconds((long)this.summary.getHighestTime()));
        this.add("Lowest Total Time: " + DateTimeUtils.toMinutesSeconds((long)this.summary.getLowestTime()));
        this.add("Average Total Time: " + DateTimeUtils.toMinutesSeconds((long)this.summary.getAverageTotalTime()));
        this.add("Average Live Time: " + DateTimeUtils.toMinutesSeconds((long)this.summary.getAverageLiveTime()));
        this.add("Average Hold Time: " + DateTimeUtils.toMinutesSeconds((long)this.summary.getAverageHoldTime()));
        this.add("# Dockets " + this.summary.getSize());
    }
}

