/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports.impl;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicReference;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.SalesSummary;
import ordermate.database.finance.reports.Summary;
import ordermate.database.misc.BusinessInfo;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.reports.impl.AbstractWaitermateReport;
import waitermate.guikit.dialogs.ProgressDialog;

public class SalesWaitermateReport
extends AbstractWaitermateReport {
    private Shift shift;

    public SalesWaitermateReport(Shift yourShift) {
        this.shift = yourShift;
    }

    @Override
    public void performReport() {
        this.add(BusinessInfo.getInstance().getName());
        this.add("");
        this.add("Shift: " + new SimpleDateFormat("E MMM d, yyyy").format(this.shift.getTradingDay().getDate()));
        this.add("Trading day commenced : " + DateTimeUtils.getSimpleTimeFormat().format(this.shift.getTradingDay().getTime()));
        this.add("");
        final AtomicReference ref = new AtomicReference();
        AbstractTask task = new AbstractTask(){

            public String getName() {
                return "Calculating Report...";
            }

            protected void performTask() throws Exception {
                SalesSummary summary = SalesSummary.getSummary((Shift)SalesWaitermateReport.this.shift);
                SalesSummary.SalesSummaryExecutable exec = new SalesSummary.SalesSummaryExecutable(summary);
                summary = (SalesSummary)PersistenceManager.getServerConnection().runSync((Executable)exec);
                ref.set(summary);
            }

            protected int getTotalSubTasks() {
                return 0;
            }
        };
        if (this.withDialog) {
            ProgressDialog.doProgressDialog((Task)task);
        } else {
            try {
                task.runLocal();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SalesSummary summary = (SalesSummary)ref.get();
        this.add("*** Sales ***");
        this.add("Shift: " + this.shift);
        this.add("");
        for (SalesSummary.InventoryGroupSummary groupSummary : summary.getInventoryGroups()) {
            this.add(groupSummary.getName());
            for (Summary itemSummary : groupSummary.getItems()) {
                this.add(itemSummary.getName());
                this.add(itemSummary.getCount() + " - " + itemSummary.getTotal());
                this.add(" ");
            }
            this.add(" -------------------- ");
            this.add("Total");
            this.add(groupSummary.getCount() + " - " + groupSummary.getTotal());
        }
        this.add("");
        this.add("Total Sales");
        this.add(summary.getCount() + " - " + summary.getTotal() + " (" + Internationalization.getLiteralFor((String)"TAX") + " " + summary.getTax() + ")");
        this.add("");
        this.add("Discounts");
        for (Summary adjSummary : summary.getDiscounts()) {
            this.add(adjSummary.getName());
            this.add(adjSummary.getCount() + " - " + adjSummary.getTotal());
        }
        this.add("Surcharge");
        for (Summary adjSummary : summary.getSurcharges()) {
            this.add(adjSummary.getName());
            this.add(adjSummary.getCount() + " - " + adjSummary.getTotal());
        }
    }
}

