/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports.impl;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.CashDrawerTakingsSummary;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.finance.reports.TakingsReportHeader;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.DebitTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.tax.TaxCodeReportItem;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.reports.impl.AbstractWaitermateReport;

public class TerminalTakingsWaitermateReport
extends AbstractWaitermateReport {
    private RestaurantTakingsSummary restaurantSummary;
    private List<CashDrawerTakingsSummary> summaries;
    private TakingsReportHeader takingsHeader;
    private Terminal terminal;

    public TerminalTakingsWaitermateReport(List<Object> newParams) {
        this.setParams(newParams);
    }

    private void setParams(List params) {
        this.restaurantSummary = (RestaurantTakingsSummary)params.get(0);
        this.summaries = (List)params.get(1);
        this.terminal = (Terminal)params.get(2);
        this.takingsHeader = (TakingsReportHeader)params.get(3);
    }

    @Override
    public void performReport() {
        this.clear();
        this.add(BusinessInfo.getInstance().getName());
        this.add("");
        this.add("Shift: " + new SimpleDateFormat("E MMM d, yyyy").format(this.takingsHeader.getShift().getTradingDay().getDate()));
        this.add("Trading day commenced : " + DateTimeUtils.getSimpleTimeFormat().format(this.takingsHeader.getShift().getTradingDay().getTime()));
        if (this.takingsHeader.getNumOpenAccounts() != 0) {
            this.add("");
            this.add("There are " + this.takingsHeader.getNumOpenAccounts() + " opened account(s)\nYou should ensure that all accounts are closedbefore change of day.");
        }
        if (this.takingsHeader.getNumOfAccountsOnOtherShifts() != 0) {
            this.add("");
            this.add("There were sales made to accounts created on previous finance shifts. Sales and takings may not balance because of this.");
        }
        this.add("");
        this.add("Takings from terminal:");
        this.add(this.terminal.getName() + " - " + this.terminal.getLocation());
        this.add("");
        List toAdd = RestaurantTakingsSummary.doPriceLevelReport((Shift)this.restaurantSummary.getShift(), (Terminal)this.terminal);
        if (toAdd != null) {
            this.add((String)toAdd.get(0) + " sold: " + (String)toAdd.get(1) + " Disc: " + (String)toAdd.get(2));
            this.add("");
        }
        for (CashDrawerTakingsSummary takings : this.summaries) {
            this.add(this.line(46));
            this.add(this.centred("Cashdrawer: " + takings.getCashDrawer().getLabel(), 46));
            this.add(this.line(46));
            this.add("");
            this.add(this.columns("Cash", takings.getCashTakings(false), 42));
            FinanceUnit cash = CashTransaction.getCashFinanceUnit();
            if (cash.isSkimmable() && Terminal.getLocalHost().getSkimming()) {
                this.add(this.columns("    " + cash.getLabel() + " level", takings.getUnitTakings(cash, true), 46));
                this.add(this.columns("    Skimmed", takings.getUnitSkims(cash), 46));
                this.add(this.columns("    Total", takings.getUnitTakings(cash, false), 46));
            }
            this.add("");
            Price credit = takings.getCreditTakings(false);
            List cards = CreditTransaction.getCreditUnitTypes();
            List<FinanceUnit> nonCards = this.getNonCards(cards);
            this.doBulkUnits("Credit", credit, cards, takings);
            Price debit = takings.getDebitTakings(false);
            cards = DebitTransaction.getDebitUnitTypes();
            nonCards.addAll(this.getNonCards(cards));
            this.doBulkUnits("Debit", debit, cards, takings);
            Price nonCardTotal = Price.ZERO_DOLLAR;
            for (FinanceUnit unit : nonCards) {
                nonCardTotal = nonCardTotal.add(takings.getUnitTakings(unit, false));
            }
            this.add(this.columns("All cards total", credit.add(debit).subtract(nonCardTotal), 42));
            if (!takings.getTotalCashOut().equals((Object)Price.ZERO_DOLLAR)) {
                this.add(this.columns("Cashout", takings.getTotalCashOut(), 42));
            }
            this.add(this.columns("Non-cards total", nonCardTotal, 42));
            this.add("");
            Price web = takings.getWebTakings(false);
            this.doBulkUnits("Web", web, FinanceUnit.getWebUnits(), takings);
            this.add(" ");
            this.add(this.columns("Total", takings.getTotalTakings(), 42));
            this.add("");
            this.add("Tip Summary");
            this.add(this.columns("Cash Tips", takings.getCashTips(), 42));
            this.add(this.columns("All Cards Tips", takings.getTotalCardTips(), 42));
            for (FinanceUnit unit : FinanceUnit.getCardPayableUnits()) {
                this.add(this.columns("    " + unit.getLabel(), takings.getSubtypeTips().get(unit), 42));
            }
            this.add(this.columns("All Cards Total inc. tips", credit.add(debit).add(takings.getTotalCardTips()), 42));
            this.add(this.columns("All Web Tips", takings.getTotalWebTips(), 42));
            for (FinanceUnit unit : FinanceUnit.getWebUnits()) {
                this.add(this.columns("    " + unit.getLabel(), takings.getSubtypeTips().get(unit), 42));
            }
            this.add(this.columns("All Web Total inc. tips", web.add(takings.getTotalWebTips()), 42));
            this.add("");
            this.displayTerminalAccountTakings(takings);
            this.add("");
            this.add(this.columns(Internationalization.getLiteralFor((String)"VOUCHER_REDEEMS") + ":", takings.getTotalVoucherRedeems() != null ? takings.getTotalVoucherRedeems() : Price.ZERO_DOLLAR, 42));
            this.add(this.columns(Internationalization.getLiteralFor((String)"VOUCHER_TOPUPS") + " (Terminal):", takings.getTerminalVoucherPurchases() != null ? takings.getTerminalVoucherPurchases() : Price.ZERO_DOLLAR, 42));
            this.add(this.columns(Internationalization.getLiteralFor((String)"VOUCHER_REDEEM_REVERSALS") + ":", takings.getTerminalVoucherRedeemReversals() != null ? takings.getTerminalVoucherRedeemReversals() : Price.ZERO_DOLLAR, 42));
            this.add(this.columns(Internationalization.getLiteralFor((String)"VOUCHER_TOPUP_REVERSALS") + ":", takings.getTerminalVoucherTopupReversals() != null ? takings.getTerminalVoucherTopupReversals() : Price.ZERO_DOLLAR, 42));
            this.add("");
            this.add(this.line(46));
        }
        this.add("Total for Section");
        if (SystemProperty.getInstance().isTakingsExDiscounts()) {
            this.add("Total for Section");
            this.add(this.restaurantSummary.getNumAccountsTotal(true) + " Open Accounts");
            this.add("  Total Ex Discounts:  " + this.restaurantSummary.getAccountsTotalExDiscounts(true));
            this.add("  Total Inc Discounts: " + this.restaurantSummary.getAccountsTotal(true));
            this.add(this.restaurantSummary.getNumAccountsTotal(false) + " Closed Accounts");
            this.add("  Total Ex Discounts:  " + this.restaurantSummary.getAccountsTotalExDiscounts(false));
            this.add("  Total Inc Discounts: " + this.restaurantSummary.getAccountsTotal(false));
        } else {
            this.add("Total (open):   " + this.restaurantSummary.getAccountsTotal(true) + ", " + this.restaurantSummary.getNumAccountsTotal(true) + " accounts");
            this.add("Total (closed): " + this.restaurantSummary.getAccountsTotal(false) + ", " + this.restaurantSummary.getNumAccountsTotal(false) + " accounts");
        }
        this.add(" ");
        this.add(" ");
        if (SystemProperty.getInstance().isTakingsExDiscounts()) {
            this.add("Total Ex Discounts:  " + this.restaurantSummary.getAccountsTotalExDiscounts() + ", " + this.restaurantSummary.getNumAccountsTotal() + " accounts");
            this.add("Total Inc Discounts: " + this.restaurantSummary.getAccountsTotal() + ", " + this.restaurantSummary.getNumAccountsTotal() + " accounts");
        } else {
            this.add("Total: " + this.restaurantSummary.getAccountsTotal() + ", " + this.restaurantSummary.getNumAccountsTotal() + " accounts");
        }
        this.add("");
        String taxWord = Internationalization.getLiteralFor((String)"GST");
        for (TaxCodeReportItem taxItem : this.restaurantSummary.getTaxSalesTotals()) {
            TaxCode taxCode = taxItem.getTaxCode();
            taxItem.getTaxCode();
            if (!taxCode.equals((Object)TaxCode.getFreeCode())) {
                this.add(this.columns("Sales Subject to " + taxWord + ": ", taxItem.getAmount(), 42));
                continue;
            }
            this.add(this.columns(taxWord + " Free Sales:", taxItem.getAmount(), 42));
        }
        for (TaxCodeReportItem taxItem : this.restaurantSummary.getTaxPaidTotals()) {
            if (taxItem.getTaxCode().getRate() == 0.0) continue;
            this.add(this.columns(taxItem.getTaxCode().getCode() + " Component:  ", taxItem.getAmount(), 42));
        }
        this.add("Total Sales Ex " + Internationalization.getLiteralFor((String)"GST") + ": " + this.restaurantSummary.getAccountsTotalExTax());
        this.add(" ");
        if (SystemProperty.getInstance().isTakingsExDiscounts()) {
            this.add("Sales Category Breakdown Ex Discounts");
            this.add("(Including Tabs/Cust Acc)");
            for (RestaurantTakingsSummary.LocationSales location : this.restaurantSummary.getLocationSales()) {
                this.add(location.getLocationName() + " - " + location.getTotalSalesExDiscounts());
                for (String category : location.getCategories()) {
                    this.add(this.columns("  " + category + " - " + location.getNumItemsForCategory(category), location.getSalesForCategoryExDiscounts(category), 42));
                }
            }
            this.add(" ");
        }
        this.add(" ");
        this.add("Sales Category Breakdown Inc Discounts");
        this.add("(Including Tabs/Cust Acc)");
        for (RestaurantTakingsSummary.LocationSales location : this.restaurantSummary.getLocationSales()) {
            this.add(location.getLocationName() + " - " + location.getTotalSales());
            for (String category : location.getCategories()) {
                this.add(this.columns("  " + category + " - " + location.getNumItemsForCategory(category), location.getSalesForCategory(category), 42));
            }
        }
        this.add("");
        this.add("");
        this.add(Internationalization.getLiteralFor((String)"COVERS"));
        this.add("(Table accounts only)");
        this.add(this.columns("  Number of " + Internationalization.getLiteralFor((String)"COVERS"), this.restaurantSummary.getNumPatrons(), 42));
        this.add(this.columns("  Dollars per head", this.restaurantSummary.getDollarsPerHead(), 42));
    }

    private List<FinanceUnit> getNonCards(List<FinanceUnit> fromThese) {
        ArrayList<FinanceUnit> toReturn = new ArrayList<FinanceUnit>();
        for (FinanceUnit unit : fromThese) {
            if (unit.isUsesEftpos()) continue;
            toReturn.add(unit);
        }
        return toReturn;
    }

    private void doBulkUnits(String label, Price total, List<FinanceUnit> units, CashDrawerTakingsSummary takings) {
        this.add(this.columns(label, total, 42));
        this.doUnits(units, takings);
    }

    private void doUnits(List<FinanceUnit> units, CashDrawerTakingsSummary takings) {
        for (FinanceUnit unit : units) {
            if (!"ACTIVE".equals(unit.getSystemState()) && Price.ZERO_DOLLAR.equals((Object)takings.getUnitTakings(unit, true))) continue;
            if (unit.isSkimmable() && Terminal.getLocalHost().getSkimming()) {
                this.add("");
                this.add(this.columns("    " + unit.getLabel() + " level", takings.getUnitTakings(unit, true), 46));
                this.add(this.columns("    Skimmed", takings.getUnitSkims(unit), 46));
                this.add(this.columns("    Total", takings.getUnitTakings(unit, false), 46));
                this.add("");
                continue;
            }
            this.add(this.columns("    " + unit.getLabel(), takings.getUnitTakings(unit, false), 46));
        }
    }

    private void displayTerminalAccountTakings(CashDrawerTakingsSummary takings) {
        List debtorTakings = takings.getDebtorReportList();
        for (Pair nextPair : debtorTakings) {
            if (nextPair.value == null) {
                this.add((String)nextPair.key);
                continue;
            }
            this.add((String)nextPair.key + " " + (String)nextPair.value);
        }
    }
}

