/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.shift;

import au.com.ordermate.guicore.task.BasicTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.ShiftChanger;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.services.database.ChangeTradingDayExecutable;
import ordermate.services.finance.CreateShiftExecutable;
import waitermate.LoginManager;
import waitermate.WaiterMateUpdater;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.OnePressPopupWindow;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;

public class ChangeTradingDayOrShift {
    private static final String WILDCARD = "%s";
    private static final String WILDCARD_SPACED = " %s ";
    private static final String YES = Internationalization.getLiteralFor((String)"YES");
    private static final String NO = Internationalization.getLiteralFor((String)"NO");
    private static final String NEW_TRADING_DAY = Internationalization.getLiteralFor((String)"NEW_TRADING_DAY");
    private static final String CHANGE_SHIFT = Internationalization.getLiteralFor((String)"CHANGE_SHIFT");
    private static final String FOR_ALL_TERMINALS = Internationalization.getLiteralFor((String)"FOR_ALL_TERMINALS");
    private static final String CURRENT_SHIFT = Internationalization.getLiteralFor((String)"CURRENT_SHIFT");
    private static final String ALL_TERMINALS_WERE_CHANGED_TO_SHIFT = Internationalization.getLiteralFor((String)"ALL_TERMINALS_WERE_CHANGED_TO_SHIFT");
    private static final String SELECT_SHIFT = Internationalization.getLiteralFor((String)"SELECT_SHIFT");
    private static final String THERE_ARE_X_OPEN_ACCOUNTS = Internationalization.getLiteralFor((String)"THERE_ARE_X_OPEN_ACCOUNTS_1") + " %s " + Internationalization.getLiteralFor((String)"THERE_ARE_X_OPEN_ACCOUNTS_2");
    private static final String CHANGE_TRADING_DAY_QUESTIONMARK = Internationalization.getLiteralFor((String)"DO_YOU_WANT_TO_CONTINUE_QUESTIONMARK");
    private static final String OPEN_ACCOUNTS_WARNING_PROMPT = Internationalization.getLiteralFor((String)"CHANGING_TRADING_DAY_WHILE_THERE_ARE_STILL_ACCOUNTS_OPEN_MAY_CAUSE_DISCREPANCIES_BETWEEN_THE_SALES_REPORT_AND_MY_TILLS_1") + "<br>" + Internationalization.getLiteralFor((String)"CHANGING_TRADING_DAY_WHILE_THERE_ARE_STILL_ACCOUNTS_OPEN_MAY_CAUSE_DISCREPANCIES_BETWEEN_THE_SALES_REPORT_AND_MY_TILLS_2") + "<br>" + Internationalization.getLiteralFor((String)"CHANGING_TRADING_DAY_WHILE_THERE_ARE_STILL_ACCOUNTS_OPEN_MAY_CAUSE_DISCREPANCIES_BETWEEN_THE_SALES_REPORT_AND_MY_TILLS_3") + HtmlUtils.newline((int)2) + CHANGE_TRADING_DAY_QUESTIONMARK;
    private static final String NEW_TRADING_DAY_CREATED_FOR = Internationalization.getLiteralFor((String)"NEW_TRADING_DAY_CREATED_FOR");
    private static final String NEW_TRADING_DAY_ = Internationalization.getLiteralFor((String)"NEW_TRADING_DAY_");
    private static final String CANNOT_CHANGE_TRADING_DAY_UNTIL = Internationalization.getLiteralFor((String)"CANNOT_CHANGE_TRADING_DAY_UNTIL");
    private static final String CANNOT_CHANGE_DAY = Internationalization.getLiteralFor((String)"CANNOT_CHANGE_DAY");
    private static final String CHANGE_OF_DAY_COULD_NOT_OCCUR_NOT_YET = Internationalization.getLiteralFor((String)"CHANGE_OF_DAY_COULD_NOT_OCCUR_NOT_YET");
    private static final String THE_FOLLOWING_TERMINALS_SHARE_CASH_DRAWERS_WITH_THIS_TERMINAL = Internationalization.getLiteralFor((String)"THE_FOLLOWING_TERMINALS_SHARE_CASH_DRAWERS_WITH_THIS_TERMINAL");
    private static final String THEY_WILL_ALSO_BE_CHANGED_ONTO_THE_X_SHIFT = Internationalization.getLiteralFor((String)"THEY_WILL_ALSO_BE_CHANGED_ONTO_THE_X_SHIFT_1") + " %s " + Internationalization.getLiteralFor((String)"THEY_WILL_ALSO_BE_CHANGED_ONTO_THE_X_SHIFT_2");
    private static final String DO_YOU_WANT_TO_CONTINUE_QUESTIONMARK = Internationalization.getLiteralFor((String)"DO_YOU_WANT_TO_CONTINUE_QUESTIONMARK");
    private static final String MULTIPLE_TERMINAL_CHANGE = Internationalization.getLiteralFor((String)"MULTIPLE_TERMINAL_CHANGE");
    private static final String THIS_TERMINALS_AND_X_WITH_SHARED_CASHDRAWERS_WERE_CHANGED_TO_SHIFT = Internationalization.getLiteralFor((String)"THIS_TERMINALS_AND_X_WITH_SHARED_CASHDRAWERS_WERE_CHANGED_TO_SHIFT_1") + " %s " + Internationalization.getLiteralFor((String)"THIS_TERMINALS_AND_X_WITH_SHARED_CASHDRAWERS_WERE_CHANGED_TO_SHIFT_2");
    private static final String THIS_TERMINAL_WAS_CHANGED_TO_SHIFT = Internationalization.getLiteralFor((String)"THIS_TERMINAL_WAS_CHANGED_TO_SHIFT");
    private JDialog changeDayDialog;

    public void start() {
        NavBar bar = new NavBar();
        final PopupWindow popDog = new PopupWindow(bar);
        bar.addLeft((Component)bar.getBackButton());
        if (SystemProperty.getInstance().isManualChangeOfDay()) {
            JButton changeDayButton = this.makeButton(NEW_TRADING_DAY, "/waitermate/images/newTradingDay.png");
            StandardSecurityDecorator changeDayDecorator = new StandardSecurityDecorator((JComponent)changeDayButton, AllPermissions.NEW_TRADING_DAY);
            changeDayButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChangeTradingDayOrShift.this.gotChangeTradingDay();
                    popDog.gotOk();
                }
            });
            bar.addRight((Component)changeDayDecorator);
        }
        if (Shift.getShiftNames().length > 1) {
            JButton shiftButton = this.makeButton(HtmlUtils.html((String)CHANGE_SHIFT), "/waitermate/images/clock.png");
            shiftButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChangeTradingDayOrShift.this.gotChangeShift();
                    popDog.gotOk();
                }
            });
            JButton shiftAllButton = this.makeButton(HtmlUtils.html((String)(CHANGE_SHIFT + "<br>" + FOR_ALL_TERMINALS)), "/waitermate/images/clock.png");
            shiftAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChangeTradingDayOrShift.this.gotChangeShiftAll();
                    popDog.gotOk();
                }
            });
            bar.addRight((Component)shiftButton);
            bar.addRight((Component)shiftAllButton);
        }
        JLabel currentShift = new JLabel(new HtmlBuilder().append(CURRENT_SHIFT + ": " + Terminal.getLocalHost().getShift().toString()).heading(1).toString());
        popDog.setComponent((JComponent)currentShift);
        popDog.start();
    }

    private void doChangeShift(Shift shift) {
        WaiterMateUpdater.getInstance().getUpdateTask().run();
        WaiterMateUpdater.getInstance().refreshQuickSaleAccount();
    }

    private void gotChangeShiftAll() {
        Shift newShift = this.selectShift();
        if (newShift != null) {
            this.changeShiftAllTerminals(newShift);
        }
    }

    private void changeShiftAllTerminals(Shift newShift) {
        List terminals = Terminal.getAllTerminals();
        for (Terminal term : terminals) {
            if (term.getShift().equals((Object)newShift)) continue;
            newShift.addTerminal(term);
            if (!term.getTerminalType().equals("ServerMate")) continue;
            PersistenceManager.getServerConnection().runSync((Executable)new ShiftChanger(newShift));
        }
        this.doChangeShift(newShift);
        TerminalEventLog.logShiftChange((User)LoginManager.getEventContext().getUser(), (Terminal)Terminal.getLocalHost(), (String)(ALL_TERMINALS_WERE_CHANGED_TO_SHIFT + " " + newShift.getName()));
    }

    private JButton makeButton(String text, String icon) {
        JButton button = new JButton(text, IconLoader.get((String)icon));
        OrderMateTheme.setupTransparentButton((AbstractButton)button);
        return button;
    }

    private Shift selectShift() {
        Shift toReturn;
        String[] shifts = Shift.getShiftNames();
        List buttons = AbstractScrollPaneModel.constructButtons((String[])shifts);
        OnePressPopupWindow shiftNamePopup = new OnePressPopupWindow(SELECT_SHIFT, (Collection)buttons, 1, 4, true);
        JButton selectedButton = shiftNamePopup.start();
        if (selectedButton == null) {
            return null;
        }
        String newShiftName = selectedButton.getText();
        TradingDay today = (TradingDay)PersistenceManager.reacquire((PersistentObjectI)TradingDay.getCurrentTradingDay());
        if (Shift.hasShift((TradingDay)today, (String)newShiftName)) {
            toReturn = Shift.getShift((TradingDay)today, (String)newShiftName);
        } else {
            ConfigShift shift = ConfigShift.getConfigShiftWithName((String)newShiftName);
            toReturn = (Shift)PersistenceManager.getServerConnection().runSync((Executable)new CreateShiftExecutable(today, shift));
        }
        return toReturn;
    }

    private void gotChangeTradingDay() {
        if (TradingDay.needsNewTradingDay()) {
            boolean changeDay = true;
            int numAccounts = TradingDay.getCurrentTradingDay().getNumOpenAcounts();
            if (numAccounts > 0) {
                String dialogMessage = HtmlUtils.html((String)(THERE_ARE_X_OPEN_ACCOUNTS.replace(WILDCARD, String.valueOf(numAccounts)) + OPEN_ACCOUNTS_WARNING_PROMPT));
                changeDay = Dialogs.displayChoiceDialog((String)dialogMessage, (String)CHANGE_TRADING_DAY_QUESTIONMARK, (String)YES, (String)NO, (boolean)true);
            }
            if (changeDay) {
                this.startChangeOfTradingDay();
            }
        } else {
            DateFormat formatter = DateFormat.getTimeInstance(3);
            String time = formatter.format(SystemProperty.getInstance().getChangeDayTime());
            Dialogs.displayOkDialog((String)(CANNOT_CHANGE_TRADING_DAY_UNTIL + " " + time + "."), (String)CANNOT_CHANGE_DAY);
            OrderMate.LOG.info(CHANGE_OF_DAY_COULD_NOT_OCCUR_NOT_YET + " " + time);
        }
    }

    private void startChangeOfTradingDay() {
        final User user = LoginManager.getInstance().getUser();
        final Terminal terminal = Terminal.getLocalHost();
        this.changeDayDialog = new JDialog();
        this.changeDayDialog.setUndecorated(true);
        this.changeDayDialog.setModal(false);
        this.changeDayDialog.setAlwaysOnTop(true);
        BasicTask task = new BasicTask("Changing trading day...", 0, new Runnable(){

            @Override
            public void run() {
                PersistenceManager.getServerConnection().runSync((Executable)new ChangeTradingDayExecutable(user, terminal));
            }
        });
        task.done.connect((Object)this, "gotTradingDayChanged");
        ProgressDialog.createProgressDialog((JDialog)this.changeDayDialog, (Task)task).start(true);
        this.changeDayDialog.setLocationRelativeTo(ScreenResource.getTarget());
        this.changeDayDialog.setVisible(true);
    }

    void gotTradingDayChanged() {
        this.changeDayDialog.setVisible(false);
        final TradingDay newDay = TradingDay.getCurrentTradingDay();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Dialogs.displayOkDialog((String)(NEW_TRADING_DAY_CREATED_FOR + " " + newDay.getLabel()), (String)NEW_TRADING_DAY_);
                    WaiterMateUpdater.getInstance().getUpdateTask().run();
                }
            });
        } else {
            Dialogs.displayOkDialog((String)(NEW_TRADING_DAY_CREATED_FOR + " " + newDay.getLabel()), (String)NEW_TRADING_DAY_);
            WaiterMateUpdater.getInstance().getUpdateTask().run();
        }
        this.changeDayDialog = null;
    }

    void gotChangeShift() {
        Shift newShift = this.selectShift();
        if (newShift != null) {
            Terminal localhost = Terminal.getLocalHost();
            HashSet<Terminal> otherTerms = new HashSet<Terminal>();
            StringBuilder otherTermList = new StringBuilder();
            List cashdrawers = localhost.getAvailableLogicallyConnectedCashDrawers();
            for (CashDrawer cashdrawer : cashdrawers) {
                for (Terminal term : cashdrawer.getLogicallyConnectedTerminals()) {
                    if (term.equals((Object)localhost) || term.getShift().equals((Object)newShift)) continue;
                    if (!otherTerms.isEmpty()) {
                        otherTermList.append(", ");
                    }
                    otherTermList.append(term.getName());
                    otherTerms.add(term);
                }
            }
            if (!otherTerms.isEmpty()) {
                String message = new HtmlBuilder().append(THE_FOLLOWING_TERMINALS_SHARE_CASH_DRAWERS_WITH_THIS_TERMINAL).append(":").appendLineBreak().append(otherTermList.toString()).appendLineBreak(2).append(THEY_WILL_ALSO_BE_CHANGED_ONTO_THE_X_SHIFT.replace(WILDCARD, newShift.getLabel())).appendLineBreak().append(DO_YOU_WANT_TO_CONTINUE_QUESTIONMARK).toString();
                boolean portOthers = Dialogs.displayChoiceDialog((String)message, (String)MULTIPLE_TERMINAL_CHANGE, (String)YES, (String)NO, (boolean)false);
                if (portOthers) {
                    for (Terminal term : otherTerms) {
                        newShift.addTerminal(term);
                    }
                    newShift.addTerminal(Terminal.getLocalHost());
                    this.doChangeShift(newShift);
                    TerminalEventLog.logShiftChange((User)LoginManager.getEventContext().getUser(), (Terminal)Terminal.getLocalHost(), (String)(THIS_TERMINALS_AND_X_WITH_SHARED_CASHDRAWERS_WERE_CHANGED_TO_SHIFT.replace(WILDCARD, otherTermList) + newShift.getName()));
                }
            } else {
                newShift.addTerminal(Terminal.getLocalHost());
                this.doChangeShift(newShift);
                TerminalEventLog.logShiftChange((User)LoginManager.getEventContext().getUser(), (Terminal)Terminal.getLocalHost(), (String)(THIS_TERMINAL_WAS_CHANGED_TO_SHIFT + " " + newShift.getName()));
            }
        }
    }
}

