/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.skims;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.dialogs.ViewSkimsDialog;
import waitermate.gui.screens.admin.skims.SkimsGui;
import waitermate.gui.screens.admin.skims.createskim.CreateSkim;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class Skims
extends AbstractScreen {
    private SkimsGui gui;
    private NavBar nav;
    private CreateSkim createSkimState;
    private ViewSkimsDialog viewSkims;
    public final Signal back = Signals.createSignal();
    public final Signal ok = Signals.createSignal();

    public Skims() {
        this.gui = new SkimsGui();
        this.gui.createSkim.connect((Object)this, "gotCreateSkim");
        this.gui.viewSkims.connect((Object)this, "gotViewSkims");
        this.nav = new NavBar();
        this.nav.back.connect((Object)this.back, "emit");
        this.nav.ok.connect((Object)this.ok, "emit");
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.setText("Cashdrawer Skims");
        this.createSkimState = new CreateSkim();
        this.createSkimState.cancel.connect((Object)this, "start");
        this.createSkimState.done.connect((Object)this, "start");
        this.viewSkims = new ViewSkimsDialog();
        this.viewSkims.printSignal.connect((Object)this, "gotPrintSkims");
    }

    public void start() {
        this.display();
    }

    public void gotCreateSkim() {
        List drawers = Terminal.getLocalHost().getAvailableCashDrawers(LoginManager.getInstance().getUser());
        if (drawers != null && drawers.size() > 0) {
            this.createSkimState.start((CashDrawer)drawers.get(0));
        } else {
            Dialogs.displayOkDialog((String)"Could not find any cashdrawers connected to this terminal", (String)"Error");
        }
    }

    public void gotPrintSkims() {
        ArrayList theSkims = new ArrayList();
        Shift theShift = Terminal.getLocalHost().getShift();
        List drawers = Terminal.getLocalHost().getAvailableCashDrawers(LoginManager.getInstance().getUser());
        for (CashDrawer drawer : drawers) {
            theSkims.addAll(Skim.getSkims((Shift)theShift, (CashDrawer)drawer));
        }
        try {
            DocketProcessor.printSkimDocket((Terminal)Terminal.getLocalHost(), (Collection)Terminal.getLocalHost().getAvailableReceiptPrinters(), theSkims);
        }
        catch (IOException e) {
            WaiterMate.LOG.error("Couldn't print skim", (Throwable)e);
        }
    }

    public void gotViewSkims() {
        boolean done = this.viewSkims.display(Terminal.getLocalHost().getShift(), Terminal.getLocalHost());
        if (!done) {
            Dialogs.displayOkDialog((String)"No skims to show for this shift", (String)"No skims");
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }
}

