/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.skims.createskim;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.SkimTransaction;
import ordermate.database.finance.reports.CashDrawerTakingsSummary;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.keypad.KeypadModel;
import ordermate.gui.keypad.PriceModel;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.SkimTransactionSubType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.skims.createskim.SkimTransactionRenderer;
import waitermate.guikit.dialogs.Dialogs;

class CreateSkimGui
extends JPanel {
    public static final int PAID_EDIT = 1;
    public static final int TIP_EDIT = 2;
    public static final int TENDERED_EDIT = 3;
    private final Keypad keypad;
    private final RendererScrollPaneModel model;
    private final CustomScrollPane scrollPane;
    public final Signal<Price, ?, ?, ?, ?> amountUpdated = Signals.createSignal(Price.class, (String)"amount");
    public final Signal<SkimTransactionSubType, ?, ?, ?, ?> selectedUpdated = Signals.createSignal(SkimTransactionSubType.class, (String)"amount");

    public CreateSkimGui() {
        super((LayoutManager)new GraphPaperLayout(new Dimension(25, 20)));
        JLabel amountLabel = new JLabel("Amount:");
        JLabel keypadLabel = new JLabel();
        this.keypad = new Keypad.KeypadBuilder().setOutputLabel(keypadLabel).build();
        this.keypad.setModel((KeypadModel)new PriceModel());
        this.keypad.setRenderer(Keypad.PRICE_RENDERER);
        this.keypad.setFirstPress(true);
        JPanel keypadPanel = new JPanel();
        keypadPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 10)));
        keypadPanel.setBorder(BorderFactory.createTitledBorder("Amount Entry"));
        keypadPanel.add((Component)amountLabel, new Rectangle(1, 0, 2, 1));
        keypadPanel.add((Component)keypadLabel, new Rectangle(3, 0, 5, 1));
        keypadPanel.add((Component)this.keypad, new Rectangle(1, 1, 8, 8));
        this.add((Component)keypadPanel, new Rectangle(13, 1, 11, 18));
        SkimTransactionRenderer renderer = new SkimTransactionRenderer();
        renderer.selected.connect((Object)this, "gotSelected");
        this.model = new RendererScrollPaneModel((Renderer)renderer, 1, 5);
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.add((Component)this.scrollPane, new Rectangle(1, 1, 11, 18));
        this.keypad.updated.connect((Object)this, "keypadUpdated");
    }

    public void reset(CashDrawerTakingsSummary summary) {
        this.model.removeAllObjects();
        this.setupSubTypeButtons(summary);
        this.model.clearSelection();
        this.enableKeypad(false);
        this.keypad.setValue("");
    }

    public void refresh() {
        this.scrollPane.displayPage(this.scrollPane.getCurrentPage());
    }

    public Price getSkimTotal() {
        List items = this.model.getObjects();
        Price total = new Price(0.0);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            SkimTransaction current = ((SkimTransactionSubType)it.next()).getTransaction();
            total = total.add(current.getAmount());
        }
        return total;
    }

    public void setupSubTypeButtons(CashDrawerTakingsSummary summary) {
        ArrayList<SkimTransactionSubType> subTypesList = new ArrayList<SkimTransactionSubType>();
        for (FinanceUnit currentSubType : FinanceUnit.getAllUnits()) {
            if (!currentSubType.isSkimmable()) continue;
            SkimTransaction newTrans = new SkimTransaction();
            newTrans.setFinanceUnit(currentSubType);
            newTrans.setAmount(new Price(0.0, 0.01));
            SkimTransactionSubType newTransSubType = new SkimTransactionSubType(newTrans, summary);
            subTypesList.add(newTransSubType);
        }
        this.model.setObjects(subTypesList);
        if (subTypesList.isEmpty()) {
            Dialogs.displayOkDialog((String)"<html>No transaction types have been set as skimmable.<br>Transaction types can be set as skimmable by using<br>the OrderMate Administration.</html>", (String)"No skimmable types");
        }
    }

    void gotSelected(SkimTransactionSubType selected) {
        this.selectedUpdated.emit((Object)selected);
    }

    void keypadUpdated() {
        double keypadValue = this.keypad.getValueAsDouble();
        Price tempPrice = new Price(keypadValue);
        this.amountUpdated.emit((Object)tempPrice);
    }

    public void setKeypadValue(Price amount) {
        this.keypad.setValue(String.valueOf(amount.doubleValue()));
        this.keypad.setOverwrite(true);
    }

    public List getValidTransactions() {
        ArrayList<SkimTransactionSubType> valid = new ArrayList<SkimTransactionSubType>();
        List items = this.model.getObjects();
        for (SkimTransactionSubType current : items) {
            if (!(current.getTransaction().getAmount().doubleValue() > 0.0)) continue;
            valid.add(current);
        }
        return valid;
    }

    public void enableKeypad(boolean enable) {
        this.keypad.setEnabled(enable);
    }
}

