/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.stock.stockrequisition.stockrequisitionorder;

import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.Quantity;
import ordermate.database.hardware.Terminal;
import ordermate.database.searchers.stock.StockItemSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockParLevel;
import ordermate.database.stock.requisition.StockRequisition;
import ordermate.database.stock.requisition.StockRequisitionEvent;
import ordermate.database.stock.requisition.StockRequisitionManager;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.database.stock.requisition.StockRequisitionOrderStatus;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.CustomButtonRenderer;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.displayitems.stockitems.SelectStockParLevelDialog;
import waitermate.gui.displayitems.stockitems.StockItemSearchPanel;
import waitermate.gui.screens.admin.stock.stockrequisition.stockrequisitionorder.StockRequistionOrderNavBar;
import waitermate.gui.screens.admin.stock.stockrequisition.stockrequisitionorder.StockRequistionOrderPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.dialogs.StockItemQuantityDialog;

public class StockRequisitionOrderScreen
extends AbstractScreen {
    public final Signal back = Signals.createSignal();
    StockRequistionOrderNavBar navBar;
    StockRequistionOrderPanel gui = new StockRequistionOrderPanel();
    StockRequisitionOrder localReq = null;
    StockItemSearchPanel searchPanel;
    PopupWindow searchPanelDialog;
    StockItemQuantityDialog quantityPanel;
    PopupWindow quantityPanelDialog;

    public StockRequisitionOrderScreen() {
        this.gui.item.connect((Object)this, "gotEditStockRequisition");
        this.gui.delete.connect((Object)this, "gotDeleteStockRequisition");
        this.gui.stockItem.connect((Object)this, "gotNewItem");
        this.gui.areaSelected.connect((Object)this, "gotStockAreas");
        this.navBar = new StockRequistionOrderNavBar();
        this.navBar.back.connect((Object)this, "gotBack");
        this.navBar.reasonSignal.connect((Object)this, "gotReason");
        this.navBar.deleteReqSignal.connect((Object)this, "gotDelete");
        this.navBar.printReqSignal.connect((Object)this, "gotPrint");
        this.navBar.saveReqSignal.connect((Object)this, "gotSave");
        this.navBar.updateStatusReqSignal.connect((Object)this, "gotUpdateStatus");
        this.navBar.transferReqSignal.connect((Object)this, "gotTransfer");
        this.navBar.fillParLevelSignal.connect((Object)this, "gotFillParLevel");
        this.navBar.searchStockSignal.connect((Object)this, "gotSearchStock");
        this.searchPanel = new StockItemSearchPanel(new StockItemSearcher(), false){

            @Override
            protected CustomButtonRenderer<StockItem> createRenderer() {
                return new CustomButtonRenderer<StockItem>(){

                    public Class<StockItem> getSelectedClassType() {
                        return StockItem.class;
                    }

                    protected String createComponentText(StockItem object) {
                        StringBuilder SB = new StringBuilder("<html><body>");
                        SB.append("<B>" + object.getLabel() + "</B>");
                        SB.append("</body></html>");
                        return SB.toString();
                    }
                };
            }
        };
        this.searchPanel.itemSelected.connect((Object)this, "gotNewItemSearchDialog");
        this.searchPanel.startSearch(null, false);
        String title = Internationalization.getLiteralFor((String)"SEARCH") + " " + Internationalization.getLiteralFor((String)"STOCK");
        String titleQty = Internationalization.getLiteralFor((String)"SELECT_CORRECT_ITEM") + " " + Internationalization.getLiteralFor((String)"QUANTITY");
        this.searchPanelDialog = Dialogs.createDialog((JComponent)this.searchPanel, (String)title, null, null, (boolean)true, (boolean)false, (boolean)false);
        this.quantityPanel = new StockItemQuantityDialog();
        this.quantityPanelDialog = Dialogs.createDialog((JComponent)this.quantityPanel, (String)titleQty, null, null, (boolean)true, (boolean)false, (boolean)true);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    public void startStockRequistionOrder(StockRequisitionOrder selectedStockRequsition) {
        this.gui.resetPanel();
        this.localReq = selectedStockRequsition;
        this.quantityPanel.setStockRequisitionOrder(this.localReq);
        this.updateGUI();
        this.display();
    }

    private void updateGUI() {
        this.navBar.updateButtons(this.localReq);
        this.gui.updatePanel(this.localReq);
    }

    public void gotBack() {
        if (Dialogs.displayChoiceDialog((String)"All changes will be discarded", (String)"Cancel Changes?", (boolean)true)) {
            this.performBack();
        }
    }

    public void performBack() {
        this.localReq.unlock();
        this.localReq = null;
        this.back.emit();
    }

    public void gotReason() {
        String oldReason = this.localReq.getReason();
        String returned = Dialogs.getString((String)"Reason: ", (String)oldReason);
        if (!"\u0000".equals(returned)) {
            this.localReq.setReason(returned);
        }
    }

    public void gotSave() {
        if (this.localReq.getUser() == null) {
            this.localReq.setUser(LoginManager.getEventContext().getUser());
        }
        this.localReq.save();
        this.performBack();
    }

    public void gotDelete() {
        if (Dialogs.displayChoiceDialog((String)"This will permenantly delete the Stock Requisition", (String)"Delete Requisition?", (boolean)true)) {
            this.localReq.delete();
            this.performBack();
        }
    }

    public void gotPrint() {
        try {
            DocketProcessor.printStockRequisitionDocket((StockRequisitionOrder)this.localReq, (List)Terminal.getLocalHost().getAvailableReceiptPrinters(), (EventContext)LoginManager.getEventContext());
        }
        catch (IOException e) {
            OrderMate.LOG.error("Printer connectivity error! ", (Throwable)e);
        }
    }

    public void gotUpdateStatus() {
        if (Dialogs.displayChoiceDialog((String)StockRequisitionOrderStatus.getDialogText((StockRequisitionOrderStatus)this.localReq.getStatus()), (String)"Confirm?", (boolean)true)) {
            this.localReq.setStatus(StockRequisitionOrderStatus.getNext((StockRequisitionOrderStatus)this.localReq.getStatus()));
            if (StockRequisitionOrderStatus.PICKING.equals((Object)this.localReq.getStatus())) {
                this.localReq.setUserAccepted(LoginManager.getEventContext().getUser());
            }
            this.localReq.addEvent(new StockRequisitionEvent(this.localReq.getUser(), this.localReq.getStatus()));
            this.gotSave();
        }
    }

    public void gotTransfer() {
        if (Dialogs.displayChoiceDialog((String)StockRequisitionOrderStatus.getDialogText((StockRequisitionOrderStatus)this.localReq.getStatus()), (String)"Perform Transfer?", (boolean)true)) {
            StockRequisitionManager.performTransfer((StockRequisitionOrder)this.localReq);
            this.localReq.setStatus(StockRequisitionOrderStatus.getNext((StockRequisitionOrderStatus)this.localReq.getStatus()));
            this.localReq.addEvent(new StockRequisitionEvent(this.localReq.getUser(), this.localReq.getStatus()));
            this.gotSave();
        }
    }

    public void gotSearchStock() {
        Dialogs.displayDialog((PopupWindow)this.searchPanelDialog, null, null);
    }

    public void gotFillParLevel() {
        StockArea parLevelToApply = this.gui.getStockAreaSelector().getStockAreaTo();
        SelectStockParLevelDialog parLevelDialog = new SelectStockParLevelDialog(parLevelToApply);
        CustomButton<StockParLevel> selectedButton = parLevelDialog.start();
        StockParLevel selected = (StockParLevel)selectedButton.getData();
        if (selected != null) {
            StockRequisitionManager.applyParLevelsToOrder((StockParLevel)selected, (StockRequisitionOrder)this.localReq, (boolean)parLevelDialog.isRoundToOuter());
        }
        this.updateGUI();
    }

    public void gotNewItemSearchDialog(StockItem theNewItem) {
        this.searchPanelDialog.gotOk();
        this.gotNewItem(theNewItem);
    }

    public void gotNewItem(StockItem theNewItem) {
        StockRequisition stockReq = new StockRequisition(theNewItem);
        stockReq.setRawQuantity(0.0);
        this.gotEditStockRequisition(stockReq);
    }

    public void gotEditStockRequisition(StockRequisition stockReq) {
        this.quantityPanel.setStockAreaTo(this.gui.getStockAreaSelector().getStockAreaTo());
        this.quantityPanel.setStockAreaFrom(this.gui.getStockAreaSelector().getStockAreaFrom());
        this.quantityPanel.setStockRequisition(stockReq);
        if (Dialogs.displayDialog((PopupWindow)this.quantityPanelDialog, null, null)) {
            Quantity qty = this.quantityPanel.getQty();
            if (!qty.isZero() || StockRequisitionOrderStatus.PICKING.equals((Object)this.localReq.getStatus())) {
                stockReq.setStockQty(qty);
                this.localReq.addRequisition(stockReq);
            } else {
                this.gotDeleteStockRequisition(stockReq);
            }
            this.updateGUI();
        }
    }

    public void gotDeleteStockRequisition(StockRequisition stockReq) {
        if (StockRequisitionOrderStatus.PICKING.equals((Object)this.localReq.getStatus())) {
            stockReq.setRawQuantity(0.0);
        } else {
            this.localReq.removeRequisition(stockReq);
        }
        this.updateGUI();
    }

    public void gotStockAreas(StockArea areaFrom, StockArea areaTo) {
        this.localReq.setStockAreaReceiver(areaTo);
        this.localReq.setStockAreaSender(areaFrom);
        this.updateGUI();
    }
}

