/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.stock.stockrequisition.stockrequisitionorder;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.database.stock.requisition.StockRequisitionOrderStatus;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

public class StockRequistionOrderNavBar
extends NavBar {
    public final Signal deleteReqSignal = Signals.createSignal();
    public final Signal printReqSignal = Signals.createSignal();
    public final Signal updateStatusReqSignal = Signals.createSignal();
    public final Signal transferReqSignal = Signals.createSignal();
    public final Signal saveReqSignal = Signals.createSignal();
    public final Signal searchStockSignal = Signals.createSignal();
    public final Signal fillParLevelSignal = Signals.createSignal();
    public final Signal reasonSignal = Signals.createSignal();
    private JButton deleteRequisition = this.constructButton(IconLoader.get((String)"/waitermate/images/StockDelete_48.png"), Internationalization.getLiteralFor((String)"DELETE"), "deleteReqButton", this.deleteReqSignal);
    private JButton printRequisition = this.constructButton(IconLoader.get((String)"/waitermate/guikit/images/print.png"), Internationalization.getLiteralFor((String)"PRINT"), "printReqButton", this.printReqSignal);
    private JButton requestRequisition = this.constructButton(IconLoader.get((String)"/waitermate/images/StockRequest_48.png"), "Request", "requestReqButton", this.updateStatusReqSignal);
    private JButton acceptRequisition = this.constructButton(IconLoader.get((String)"/waitermate/images/StockAccept_48.png"), "Accept", "acceptReqButton", this.updateStatusReqSignal);
    private JButton transferRequisition = this.constructButton(IconLoader.get((String)"/waitermate/images/StockTransfer_48.png"), Internationalization.getLiteralFor((String)"TRANSFER"), "transferReqButton", this.transferReqSignal);
    private StandardSecurityDecorator transferSecurityDecorator = new StandardSecurityDecorator((JComponent)this.transferRequisition, AllPermissions.STOCK_REQUISITION_TRANSFER);
    private Map<JButton, StockRequisitionOrderStatus> buttonsToStatus;
    private JButton saveRequisition = this.constructButton(IconLoader.get((String)"/waitermate/images/save.png"), Internationalization.getLiteralFor((String)"SAVE"), "saveReqButton", this.saveReqSignal);
    private JButton searchStock = this.constructButton(IconLoader.get((String)"/waitermate/images/find.png"), Internationalization.getLiteralFor((String)"SEARCH"), "searchStockButton", this.searchStockSignal);
    private JButton fillParLevel = this.constructButton(IconLoader.get((String)"/waitermate/images/StockAutoFill_48.png"), "Auto-fill Par Level", "fillParLevelButton", this.fillParLevelSignal);
    private JButton reason = this.constructButton(IconLoader.get((String)"/waitermate/images/blue_speech_bubble_48.png"), "Reason", "reasonButton", this.reasonSignal);

    public StockRequistionOrderNavBar() {
        this.setupStatusMap();
        this.addRight(this.deleteRequisition);
        this.addRight(this.printRequisition);
        this.addRight(this.requestRequisition);
        this.addRight(this.acceptRequisition);
        this.addRight((Component)this.transferSecurityDecorator);
        this.addRight(this.saveRequisition);
        this.addLeft(this.getBackButton());
        this.addLeft(this.searchStock);
        this.addLeft(this.fillParLevel);
        this.addLeft(this.reason);
    }

    public void updateButtons(StockRequisitionOrder localReq) {
        StockRequisitionOrderStatus status = localReq.getStatus();
        this.updateButton(status, this.requestRequisition);
        this.updateButton(status, this.acceptRequisition);
        this.updateButton(status, this.transferRequisition);
        StringBuilder SB = new StringBuilder();
        SB.append("<html>").append("Created By: ").append(localReq.getUserCreated()).append("\n<br>").append(DateTimeUtils.getDateTimeFormat().format(localReq.getCreationDateTime())).append("\n<br>").append(status.toString()).append("</html>");
        this.setText(SB.toString());
    }

    private void updateButton(StockRequisitionOrderStatus status, JButton button) {
        button.setVisible(status.equals((Object)this.buttonsToStatus.get(button)));
        if (button.equals(this.transferRequisition)) {
            this.transferSecurityDecorator.setVisible(status.equals((Object)this.buttonsToStatus.get(button)));
        }
    }

    void setupStatusMap() {
        this.buttonsToStatus = new HashMap<JButton, StockRequisitionOrderStatus>();
        this.buttonsToStatus.put(this.requestRequisition, StockRequisitionOrderStatus.NEW);
        this.buttonsToStatus.put(this.acceptRequisition, StockRequisitionOrderStatus.REQUESTED);
        this.buttonsToStatus.put(this.transferRequisition, StockRequisitionOrderStatus.PICKING);
    }
}

