/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.stockcount;

import java.util.List;
import javax.swing.JComponent;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.queries.inventory.InventoryItemQueries;
import ordermate.database.sales.Account;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.additems.search.InventoryItemSearchPanel;
import waitermate.gui.screens.ordering.additems.selectunit.SelectUnit;
import waitermate.gui.screens.ordering.modifyitem.editstockcount.EditStockCount;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class StockCountScreen
extends AbstractScreen {
    private InventoryItemSearchPanel invItemSearchGui;
    private EditStockCount editStockCountScreen;
    private SpecifyItemUnit specifyItem;
    public final Signal back = Signals.createSignal();

    public StockCountScreen() {
        this.editStockCountScreen = new EditStockCount();
        this.editStockCountScreen.confrimEdit.connect(this.back);
        this.editStockCountScreen.back.connect((Object)this, "gotBackToItemSearch");
        this.invItemSearchGui = new InventoryItemSearchPanel();
        this.invItemSearchGui.back.connect(this.back);
        this.invItemSearchGui.objectSelected.connect((Object)this, "gotFoundItem");
        this.specifyItem = new SpecifyItemUnit();
        this.specifyItem.back.connect((Object)this, "gotBackToItemSearch");
        this.specifyItem.itemUnitDone.connect((Object)this, "gotFinishedItemUnit");
        List allItems = InventoryItemQueries.getInventoryItemsWithPrice();
        this.invItemSearchGui.startSearch(allItems, null, false);
    }

    public JComponent getMainArea() {
        return this.invItemSearchGui;
    }

    public NavBar getNavBar() {
        return this.invItemSearchGui.getNavBar();
    }

    public void setUp() {
        super.setUp();
    }

    void gotFoundItem(Account account, InventoryItem item) {
        if (item != null) {
            this.specifyItem.startSpecifyingItem(item, account);
        }
    }

    void gotFoundItem(InventoryItem item) {
        this.gotFoundItem(null, item);
    }

    void gotFinishedItemUnit(InventoryItemUnit newUnit) {
        this.editStockCountScreen.start(newUnit);
    }

    void gotBackToItemSearch() {
        this.display();
    }

    static class SpecifyItemUnit {
        public final Signal itemUnitDone = Signals.createSignal(InventoryItemUnit.class, (String)"New itemUnit");
        public final Signal back = Signals.createSignal();
        private SelectUnit selectUnit = new SelectUnit();

        public SpecifyItemUnit() {
            this.selectUnit.unitSelected.connect((Object)this, "gotUnit");
            this.selectUnit.back.connect(this.back);
        }

        public void startSpecifyingItem(InventoryItem selected, Account newAccount) {
            this.selectUnit(newAccount, selected.getUnits());
        }

        void selectUnit(Account newAccount, List unitsToSelect) {
            if (unitsToSelect.size() > 1) {
                this.selectUnit.selectUnit(newAccount, unitsToSelect);
            } else if (unitsToSelect.isEmpty()) {
                Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"") + Internationalization.getLiteralFor((String)"") + Internationalization.getLiteralFor((String)"") + "</html>"), (String)Internationalization.getLiteralFor((String)""));
            } else {
                this.gotUnit((InventoryItemUnit)unitsToSelect.get(0));
            }
        }

        void gotUnit(InventoryItemUnit newUnit) {
            this.itemUnitDone.emit((Object)newUnit);
        }
    }
}

