/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.surchargesdiscounts;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class SurchargesDiscountGui
extends JPanel
implements ActionListener {
    public final Signal<Displayable, ?, ?, ?, ?> deletePressed = Signals.createSignal(Displayable.class, (String)"theDiscountSurcharge");
    public final Signal<Displayable, ?, ?, ?, ?> editPriceAdjustment = Signals.createSignal(Displayable.class, (String)"theDiscountSurcharge");
    public final Signal addSurcharge = Signals.createSignal();
    private JLabel informationLabel;
    private JButton setupButton;
    private JButton maintainButton;
    private JButton removeButton;
    private InventoryPriceAdjustment currentAdjustmet;

    public SurchargesDiscountGui() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        this.informationLabel = new JLabel();
        this.informationLabel.setFont(OrderMateTheme.getLargeFont());
        this.informationLabel.setHorizontalAlignment(0);
        this.add((Component)this.informationLabel, new Rectangle(0, 4, 20, 4));
        this.setupButton = new JButton();
        this.add((Component)this.setupButton, new Rectangle(5, 8, 10, 4));
        this.setupButton.setText(Internationalization.getLiteralFor((String)"CLICK_TO_SET_SURCHARGE_OR_DISCOUNT"));
        this.setupButton.setFont(OrderMateTheme.getMediumFont());
        this.setupButton.setIcon(IconLoader.get((String)"/waitermate/images/new.png"));
        this.setupButton.addActionListener(this);
        this.setupButton.setVisible(false);
        this.maintainButton = new JButton();
        this.add((Component)this.maintainButton, new Rectangle(5, 8, 10, 4));
        this.maintainButton.setFont(OrderMateTheme.getMediumFont());
        this.maintainButton.setIcon(IconLoader.get((String)"/waitermate/images/edit.png"));
        this.maintainButton.addActionListener(this);
        this.maintainButton.setVisible(false);
        this.removeButton = new JButton();
        this.add((Component)this.removeButton, new Rectangle(5, 13, 10, 4));
        this.removeButton.setFont(OrderMateTheme.getMediumFont());
        this.removeButton.setIcon(IconLoader.get((String)"/waitermate/guikit/images/cancel.png"));
        this.removeButton.addActionListener(this);
        this.removeButton.setVisible(false);
    }

    public void setupGui(InventoryPriceAdjustment theAdjustment) {
        this.currentAdjustmet = theAdjustment;
        if (theAdjustment == null) {
            this.informationLabel.setText(Internationalization.getLiteralFor((String)"THERE_ARE_NO_SURCHARGES_OR_DISCOUNTS_TODAY"));
            this.setupButton.setVisible(true);
            this.maintainButton.setVisible(false);
            this.removeButton.setVisible(false);
        } else {
            this.informationLabel.setText(Internationalization.getLiteralFor((String)"THERE_IS_A") + " " + theAdjustment.getDirection() + " " + Internationalization.getLiteralFor((String)"TODAY") + ": " + theAdjustment.getLabel());
            this.maintainButton.setText(Internationalization.getLiteralFor((String)"CLICK_TO_EDIT") + " " + theAdjustment.getDirection());
            this.removeButton.setText(Internationalization.getLiteralFor((String)"CLICK_TO_REMOVE") + " " + theAdjustment.getDirection());
            this.setupButton.setVisible(false);
            this.maintainButton.setVisible(true);
            this.removeButton.setVisible(true);
        }
    }

    public void gotSurchargeDeleted(Displayable deleted) {
        this.deletePressed.emit((Object)deleted);
    }

    public void gotSurchargePressed(Displayable pressed) {
        this.editPriceAdjustment.emit((Object)pressed);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.setupButton) {
            this.addSurcharge.emit();
        } else if (e.getSource() == this.maintainButton) {
            this.editPriceAdjustment.emit((Object)this.currentAdjustmet);
        } else if (e.getSource() == this.removeButton) {
            this.deletePressed.emit((Object)this.currentAdjustmet);
        }
    }
}

