/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.surchargesdiscounts.addeditsurcharge;

import java.awt.Component;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.priceadjustment.inventory.TradingDayAdjustment;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.TradingDay;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.admin.surchargesdiscounts.addeditsurcharge.AddEditSurchargeGui;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class AddEditSurcharge
extends AbstractScreen {
    private AddEditSurchargeGui gui;
    private NavBar nav;
    private InventoryPriceAdjustment current;
    public final Signal back = Signals.createSignal();

    public AddEditSurcharge() {
        this.gui = new AddEditSurchargeGui();
        this.nav = new NavBar();
        this.nav.back.connect((Object)this.back, "emit");
        this.nav.ok.connect((Object)this, "gotOk");
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.addRight((Component)this.nav.getOkButton());
    }

    public void add() {
        this.current = null;
        this.gui.setupGui(null);
        this.show();
    }

    public void edit(InventoryPriceAdjustment toEdit) {
        this.current = toEdit;
        this.gui.setupGui(toEdit);
        this.show();
    }

    public void show() {
        this.gui.setupGui(this.current);
        this.display();
    }

    public void gotOk() {
        if (this.gui.getAmount() == 0.0) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"PLEASE_ENTER_AN_AMOUNT"), (String)Internationalization.getLiteralFor((String)"NO_AMOUNT_ENTERED"));
        } else {
            if (this.current != null) {
                this.current.delete();
            }
            PriceAdjustmentDirection direction = this.gui.getType();
            TradingDayAdjustment adjustment = (TradingDayAdjustment)PriceAdjustmentFactory.getInstance().createInventoryPriceAdjustment(direction, this.gui.getAmount(), this.gui.getUnit(), PriceAdjustmentType.DAILY, TradingDay.getCurrentTradingDay().getLabel() + " " + direction.toString() + " (" + this.gui.getUnit().getFormattedValue(this.gui.getAmount()) + ")");
            adjustment.setTradingDay(TradingDay.getCurrentTradingDay());
            adjustment.save();
            PriceAdjustmentManager.getInstance().clearCachedAdjustments();
            TerminalEventLog.logTradingDayAdjustment((EventContext)LoginManager.getEventContext(), (TradingDayAdjustment)adjustment, (boolean)true);
            this.back.emit();
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }
}

