/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.system;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.hardware.LocationType;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import waitermate.guikit.dialogs.OnePressPopupWindow;

class LocationSelectDialog
extends OnePressPopupWindow {
    public static final String COMPONENT_NAME = "locationSelect";
    private static final int DEFAULT_NUM_COLUMNS = 1;
    private static final int MULTIPLE_NUM_COLUMNS = 3;
    private static final int MANAGEABLE_COUNT = 5;
    private LocationType locationType = null;

    public LocationSelectDialog(String title, List locations, LocationType locationType) {
        super(title, (Collection)AbstractScrollPaneModel.constructButtons((Collection)locations), LocationSelectDialog.getPreferredColumnCount(locations.size()), LocationSelectDialog.getPreferredRowCount(locations.size()), true);
        this.parentWindow.setOkButtonVisible(true);
        this.setCloseWindow(false);
        this.setName(COMPONENT_NAME);
        this.locationType = locationType;
    }

    private static int getPreferredColumnCount(int locationCount) {
        return locationCount <= 5 ? 1 : 3;
    }

    private static int getPreferredRowCount(int locationCount) {
        return locationCount <= 5 ? locationCount : locationCount / 3 + locationCount % 3;
    }

    public JButton start() {
        if (this.locationType.equals((Object)LocationType.TerminalLocation)) {
            TerminalLocation selectedLocation = Terminal.getLocalHost().getLocation();
            for (JButton button : this.getButtons()) {
                CustomButton customButton = (CustomButton)button;
                TerminalLocation location = (TerminalLocation)customButton.getData();
                if (location.equals((Object)selectedLocation)) {
                    button.setBackground(Color.GREEN);
                    continue;
                }
                button.setBackground(null);
            }
        } else if (this.locationType.equals((Object)LocationType.SalesLocation)) {
            SalesLocation selectedLocation = Terminal.getLocalHost().getSalesLocation();
            for (JButton button : this.getButtons()) {
                CustomButton customButton = (CustomButton)button;
                SalesLocation location = (SalesLocation)customButton.getData();
                if (location.equals((Object)selectedLocation)) {
                    button.setBackground(Color.GREEN);
                    continue;
                }
                button.setBackground(null);
            }
        }
        this.selectedButton = null;
        this.parentWindow.start();
        return this.selectedButton;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.selectedButton) {
            for (JButton button : this.getButtons()) {
                CustomButton customButton = (CustomButton)button;
                customButton.setBackground(null);
            }
            this.selectedButton.setBackground(Color.GREEN);
        }
    }
}

