/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.system;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.ApplicationLauncher;
import au.com.ordermate.util.IPAddressUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.LogoutLocalWM;
import ordermate.OrderMate;
import ordermate.SafeRestartTask;
import ordermate.database.Data;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.hardware.LocationType;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.User;
import ordermate.gui.button.CustomButton;
import ordermate.internationalization.Internationalization;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.WaiterMateUpdater;
import waitermate.gui.RestartComfirmDialog;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.adjusttime.AdjustTime;
import waitermate.gui.screens.admin.guiconfig.GuiConfig;
import waitermate.gui.screens.admin.license.LicenseScreen;
import waitermate.gui.screens.admin.paireftpos.WMPairEftpos;
import waitermate.gui.screens.admin.system.LocationSelectDialog;
import waitermate.gui.screens.admin.system.SystemAdminPanel;
import waitermate.gui.screens.ordering.saveaccount.EtaPopup;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ObjectPopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;
import waitermate.guikit.task.RestartWaitermateTask;

public class SystemAdmin
extends AbstractAdminScreen {
    private SystemAdminPanel gui = new SystemAdminPanel();
    private LicenseScreen licenseGui;
    private LocationSelectDialog terminalLocationSelectDialog;
    private LocationSelectDialog salesLocationSelectDialog;
    private static final String SELECT_TERMINAL_LOCATION = "Select Terminal Location";
    private static final String SELECT_SALES_LOCATION = "Select Sales Location";
    private GuiConfig guiConfig;

    public SystemAdmin() {
        this.gui.setShowOnlineTableMode(Terminal.getLocalHost().isShowOnline());
        this.gui.exit.connect((Object)this, "gotExit");
        this.gui.about.connect((Object)this, "gotAbout");
        this.gui.license.connect((Object)this, "gotLicense");
        this.gui.optimise.connect((Object)this, "gotOptimise");
        this.gui.thisIP.connect((Object)this, "gotIP");
        this.gui.posGear.connect((Object)this, "gotPosGear");
        this.gui.officeMate.connect((Object)this, "gotOfficeMate");
        this.gui.safeRestart.connect((Object)this, "gotSafeRestart");
        this.gui.changeTerminalLocation.connect((Object)this, "gotChangeTerminalLocation");
        this.gui.changeSalesLocation.connect((Object)this, "gotChangeSalesLocation");
        this.gui.openBackupFolder.connect((Object)this, "gotOpenBackupFolder");
        this.gui.configDisplay.connect((Object)this, "gotConfigDisplay");
        this.gui.adjustTime.connect((Object)this, "gotAdjustTime");
        this.gui.clearMenuCache.connect((Object)this, "gotClearMenuCache");
        this.gui.pairEftpos.connect((Object)this, "gotPairEftpos");
        this.gui.logoutRemoteUser.connect((Object)this, "gotLogoffUser");
        this.gui.setAccountEta.connect((Object)this, "gotSetAccountEta");
        this.gui.minimise.connect((Object)this, "gotMinimise");
        this.gui.toggleOnlineTables.connect((Object)this, "gotToggleOnlineTables");
    }

    public void gotLicense() {
        if (this.licenseGui == null) {
            this.licenseGui = new LicenseScreen();
            this.licenseGui.complete.connect(this.back);
        }
        this.licenseGui.start();
    }

    @Override
    public Icon getCategoryIcon() {
        return IconLoader.get((String)"/waitermate/images/terminal.png");
    }

    @Override
    public String getCategoryName() {
        return Internationalization.getLiteralFor((String)"SYSTEM");
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    void gotExit() {
        boolean exit = Dialogs.displayChoiceDialog((String)Internationalization.getLiteralFor((String)"THIS_WILL_CLOSE_WAITERMATE_ARE_YOU_SURE"), (String)Internationalization.getLiteralFor((String)"EXIT"), (boolean)true);
        if (exit) {
            WaiterMate.LOG.warn("Exiting WaiterMate via Admin screen");
            LoginManager.exit(0);
        }
    }

    void gotAbout() {
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            WaiterMate.LOG.info("Cannot resolve terminal hostname", (Throwable)e);
        }
        Dialogs.displayOkDialog((String)("<html><b>" + Internationalization.getLiteralFor((String)"ORDERMATE_VERSION") + " " + OrderMate.VERSION + "</b><br><br>" + Internationalization.getLiteralFor((String)"TERMINAL") + " : " + hostName + "<br>" + Internationalization.getLiteralFor((String)"SHIFT") + " : " + Terminal.getLocalHost().getShift().getLabel() + "</html>"), (String)Internationalization.getLiteralFor((String)"WAITERMATE"));
    }

    void gotOptimise() {
        boolean optimise = Dialogs.displayChoiceDialog((String)("<html>" + Internationalization.getLiteralFor((String)"WAITERMATE_WILL_NOW_OPTIMISE_THE_DATABASE") + " \n" + Internationalization.getLiteralFor((String)"THIS_MAY_TAKE_SEVERAL_MINUTES") + "<br>" + Internationalization.getLiteralFor((String)"ARE_YOU_SURE_YOU_WANT_TO_CONTINUE") + "</html>"), (String)Internationalization.getLiteralFor((String)"DATABASE_OPTIMISE"), (boolean)true);
        if (optimise) {
            Data.repairAndOptimise((User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost(), null);
        }
    }

    void gotConfigDisplay() {
        if (this.guiConfig == null) {
            this.guiConfig = new GuiConfig();
            this.guiConfig.back.connect(this.back);
        }
        this.guiConfig.display();
    }

    void gotIP() throws Exception {
        String IPAddress = IPAddressUtils.getIPAddress();
        if (!IPAddress.equalsIgnoreCase("")) {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"YOUR_IP_ADDRESS_IS") + " :" + IPAddress), (String)Internationalization.getLiteralFor((String)"IP_ADDRESS"));
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"COULD_NOT_DETERMINE_YOUR_IP_ADDRESS"), (String)Internationalization.getLiteralFor((String)"IP_ADDRESS"));
        }
    }

    void gotPosGear() {
        this.openURL("http://www.posgear.com.au");
    }

    void gotOfficeMate() {
        try {
            ApplicationLauncher.launchJavaWebStart((String)("http://" + Terminal.getServerMateTerminal().getAddress().getHostName() + "/webstart/officemate.jnlp"));
        }
        catch (IOException e) {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"OFFICEMATE_COULD_NOT_BE_LOADED") + "\n" + Internationalization.getLiteralFor((String)"PLEASE_CONTACT_YOUR_ORDERMATE_REPRESENTATIVE")), (String)Internationalization.getLiteralFor((String)"COULD_NOT_LOAD_OFFICEMATE"));
            WaiterMate.LOG.error((Object)e);
        }
    }

    private void openURL(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(URI.create(url));
            } else {
                Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"COULD_NOT_OPEN") + " " + url), (String)Internationalization.getLiteralFor((String)"UNABLE_TO_OPEN_URL"));
            }
            return;
        }
        catch (Exception ex) {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"COULD_NOT_OPEN") + " " + url), (String)Internationalization.getLiteralFor((String)"UNABLE_TO_OPEN_URL"));
            WaiterMate.LOG.warn(Internationalization.getLiteralFor((String)"COULD_NOT_OPEN"), (Throwable)ex);
            return;
        }
    }

    public void gotSafeRestart() {
        SwingUtilities.invokeLater((Runnable)new RestartWaitermateTask());
        User loginedUser = LoginManager.getInstance().getUser();
        RestartComfirmDialog dialog = new RestartComfirmDialog();
        if (dialog.start()) {
            SafeRestartTask task = new SafeRestartTask();
            task.actions(dialog.openCashdrawers(), dialog.printReceipts(), loginedUser);
            ProgressDialog.doProgressDialog((Task)task);
        }
    }

    public void gotChangeTerminalLocation() {
        JButton selectedButton;
        Terminal terminal = Terminal.getLocalHost();
        if (this.terminalLocationSelectDialog == null) {
            this.terminalLocationSelectDialog = new LocationSelectDialog(SELECT_TERMINAL_LOCATION, TerminalLocation.getTerminalLocations(), LocationType.TerminalLocation);
        }
        if ((selectedButton = this.terminalLocationSelectDialog.start()) != null) {
            CustomButton button = (CustomButton)selectedButton;
            TerminalLocation newLocation = (TerminalLocation)button.getData();
            if (terminal.getLocation() != null && terminal.getLocation().equals((Object)newLocation)) {
                return;
            }
            terminal.changeTerminalLocation(newLocation);
            WaiterMateUpdater.getInstance().getUpdateTask().run();
        }
    }

    public void gotChangeSalesLocation() {
        JButton selectedButton;
        Terminal terminal = Terminal.getLocalHost();
        if (this.salesLocationSelectDialog == null) {
            this.salesLocationSelectDialog = new LocationSelectDialog(SELECT_SALES_LOCATION, SalesLocation.getSalesLocations(), LocationType.SalesLocation);
        }
        if ((selectedButton = this.salesLocationSelectDialog.start()) != null) {
            CustomButton button = (CustomButton)selectedButton;
            SalesLocation newLocation = (SalesLocation)button.getData();
            if (terminal.getSalesLocation() != null && terminal.getSalesLocation().equals((Object)newLocation)) {
                return;
            }
            terminal.changeSalesLocation(newLocation);
            WaiterMateUpdater.getInstance().getUpdateTask().run();
        }
    }

    public void gotOpenBackupFolder() {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(new File("C:\\backup\\"));
            } else {
                Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"COULD_NOT_USE_THE_DESKTOP_TO_OPEN_THE_FOLDER"), (String)Internationalization.getLiteralFor((String)"UNABLE_TO_OPEN_FOLDER"));
            }
            return;
        }
        catch (IOException ex) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"COULD_NOT_FIND_BACKUP_FOLDER"), (String)Internationalization.getLiteralFor((String)"UNABLE_TO_OPEN_FOLDER"));
        }
        catch (IllegalArgumentException ex1) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"COULD_NOT_FIND_BACKUP_FOLDER_FOR_THIS_TERMINAL"), (String)Internationalization.getLiteralFor((String)"UNABLE_TO_OPEN_FOLDER"));
        }
    }

    public void gotAdjustTime() {
        AdjustTime.adjustTime();
    }

    public void gotClearMenuCache() {
        User loggedInUser = LoginManager.getInstance().getUser();
        String reason = loggedInUser + ": Requested update.";
        SystemCurrentInfo.setUpdate((String)reason);
        WaiterMateUpdater.getInstance().getUpdateTask().run();
    }

    public void gotSetAccountEta() {
        OnlineIntegrationETA eta = this.getETAToConfigure();
        if (eta != null) {
            EtaPopup popup = new EtaPopup(true, eta);
            Integer n = popup.getEta();
        }
    }

    private OnlineIntegrationETA getETAToConfigure() {
        List etas = OnlineIntegrationETA.getAllETAs();
        if (etas.size() > 1) {
            ObjectPopupWindow optionsWindow = new ObjectPopupWindow("Which ETA would you like to set?", etas, 1, etas.size(), true, (ObjectPopupWindow.ObjectDisplayableLabelStrategy)new ObjectPopupWindow.ObjectDisplayableLabelStrategy<OnlineIntegrationETA>(){

                public String getDisplayableLabel(OnlineIntegrationETA eta) {
                    return eta.toString();
                }
            });
            return (OnlineIntegrationETA)optionsWindow.start();
        }
        return OnlineIntegrationETA.getGlobalETAConfig();
    }

    public void gotMinimise() {
        WaiterMate.minimise();
    }

    public void gotPairEftpos() {
        new WMPairEftpos().start();
    }

    public void gotLogoffUser() {
        new LogoutLocalWM((GuiHandler)new WaitermateGuiHandler()).start();
    }

    public void gotToggleOnlineTables() {
        Terminal terminal;
        terminal.setShowOnline(!(terminal = Terminal.getLocalHost()).isShowOnline());
        terminal.save();
        this.gui.setShowOnlineTableMode(terminal.isShowOnline());
    }
}

