/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.tablesetup;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import waitermate.gui.screens.admin.tablesetup.AbstractTableSetupPanel;
import waitermate.gui.screens.selectaccount.table.ButtonTableSelectionPanel;
import waitermate.gui.tablelayout.GTLMode;

public class ClassicTableSetupPanel
extends AbstractTableSetupPanel {
    private ButtonTableSelectionPanel tableDisplay;
    private JPanel sidePanel;
    private JPanel sideSquisherPanel;
    private JPanel tableButtonPanel;
    private JButton createTableButton;
    private JToggleButton editTableButton;
    private JToggleButton deleteTableButton;
    private JPanel sectionButtonPanel;
    private JButton createSectionButton;
    private JButton editSectionButton;
    private JButton deleteSectionButton;
    private GTLMode mode = GTLMode.Select;

    public ClassicTableSetupPanel() {
        this.setLayout(new BorderLayout());
        this.sidePanel = new JPanel();
        this.sidePanel.setLayout(new BoxLayout(this.sidePanel, 1));
        this.tableButtonPanel = new JPanel(new GridLayout(3, 1));
        this.sectionButtonPanel = new JPanel(new GridLayout(3, 1));
        TitledBorder border = BorderFactory.createTitledBorder("Tables");
        this.tableButtonPanel.setBorder(border);
        border = BorderFactory.createTitledBorder("Sections");
        this.sectionButtonPanel.setBorder(border);
        this.createTableButton = this.makeButton("Create", IconLoader.get((String)"/waitermate/images/icon_createtable.png"));
        this.createTableButton.setToolTipText("Create a table");
        this.deleteTableButton = this.makeToggleButton("Delete", IconLoader.get((String)"/waitermate/images/icon_deletetable.png"));
        this.deleteTableButton.setToolTipText("Delete a table");
        this.editTableButton = this.makeToggleButton("Edit", IconLoader.get((String)"/waitermate/images/icon_edittable.png"));
        this.editTableButton.setToolTipText("Edit a table");
        this.editTableButton.setSelected(true);
        this.tableButtonPanel.add(this.createTableButton);
        this.tableButtonPanel.add(this.editTableButton);
        this.tableButtonPanel.add(this.deleteTableButton);
        this.createSectionButton = this.makeButton("Create", IconLoader.get((String)"/waitermate/images/icon_createsection.png"));
        this.createSectionButton.setToolTipText("Create a section");
        this.editSectionButton = this.makeButton("Edit", IconLoader.get((String)"/waitermate/images/icon_editsection.png"));
        this.editSectionButton.setToolTipText("Edit this section");
        this.deleteSectionButton = this.makeButton("Delete", IconLoader.get((String)"/waitermate/images/icon_deletesection.png"));
        this.deleteSectionButton.setToolTipText("Delete this section");
        this.sectionButtonPanel.add(this.createSectionButton);
        this.sectionButtonPanel.add(this.editSectionButton);
        this.sectionButtonPanel.add(this.deleteSectionButton);
        this.sidePanel.add(this.tableButtonPanel);
        this.sidePanel.add(this.sectionButtonPanel);
        this.sideSquisherPanel = new JPanel(new BorderLayout());
        this.sideSquisherPanel.add((Component)this.sidePanel, "North");
        this.add((Component)this.sideSquisherPanel, "East");
        this.tableDisplay = new ButtonTableSelectionPanel(true);
        this.tableDisplay.tableGroupSelected.connect((Object)this, "gotTableGroupSelected");
        this.tableDisplay.tableSelected.connect((Object)this, "gotTableSelected");
        this.add((Component)this.tableDisplay, "Center");
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        boolean interfaceLocked = this.tableDisplay.isInterfaceLocked();
        this.createTableButton.setEnabled(!interfaceLocked);
        this.editTableButton.setEnabled(!interfaceLocked);
        this.deleteTableButton.setEnabled(!interfaceLocked);
        this.createSectionButton.setEnabled(!interfaceLocked);
        this.editSectionButton.setEnabled(!interfaceLocked);
        this.deleteSectionButton.setEnabled(!interfaceLocked);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setInterfaceLocked(boolean locked, String dialogText, String unlockButtonText) {
        this.tableDisplay.setInterfaceLocked(locked, dialogText, unlockButtonText);
        this.updateButtonStates();
    }

    @Override
    public void setInterfaceLocked(boolean locked) {
        this.tableDisplay.setInterfaceLocked(locked);
        this.updateButtonStates();
    }

    @Override
    public void addTableGroup(TableGroup group) {
        this.tableDisplay.addTableGroup(group);
    }

    @Override
    public void removeCurrentTableGroup() {
        this.tableDisplay.removeTableGroup(this.getCurrentTableGroup());
    }

    @Override
    public void setCurrentTableGroup(TableGroup tableGroup) {
        this.tableDisplay.setCurrentTableGroup(tableGroup);
        this.tableGroupSelected.emit();
    }

    @Override
    public TableGroup getCurrentTableGroup() {
        return this.tableDisplay.getCurrentTableGroup();
    }

    void gotTableSelected(LogicalTable table) {
        if (this.mode == GTLMode.Select) {
            this.editTable.emit((Object)table);
        } else if (this.mode == GTLMode.Delete) {
            this.deleteTable.emit((Object)table);
        } else {
            throw new IllegalStateException("Mode should be DELETE or SELECT.");
        }
    }

    @Override
    public void refresh() {
        this.tableDisplay.refresh();
        this.updateButtonStates();
    }

    void gotTableGroupSelected() {
        this.tableGroupSelected.emit();
        this.updateButtonStates();
    }

    @Override
    public List<TableGroup> getTableGroups() {
        return this.tableDisplay.getTableGroups();
    }

    @Override
    protected ActionListener createActionListener() {
        return new InnerActionListener();
    }

    private class InnerActionListener
    implements ActionListener {
        private InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ClassicTableSetupPanel.this.createTableButton) {
                PhysicalTable protoType = new PhysicalTable("", -1, -1);
                ClassicTableSetupPanel.this.createTable.emit((Object)protoType);
            } else if (source == ClassicTableSetupPanel.this.editTableButton) {
                ClassicTableSetupPanel.this.mode = GTLMode.Select;
                ClassicTableSetupPanel.this.updateButtonStates();
            } else if (source == ClassicTableSetupPanel.this.deleteTableButton) {
                ClassicTableSetupPanel.this.mode = GTLMode.Delete;
                ClassicTableSetupPanel.this.updateButtonStates();
            } else if (source == ClassicTableSetupPanel.this.createSectionButton) {
                ClassicTableSetupPanel.this.createTableGroupPressed.emit();
            } else if (source == ClassicTableSetupPanel.this.editSectionButton) {
                ClassicTableSetupPanel.this.editTableGroupPressed.emit();
            } else if (source == ClassicTableSetupPanel.this.deleteSectionButton) {
                ClassicTableSetupPanel.this.deleteTableGroupPressed.emit();
            }
            ClassicTableSetupPanel.this.repaint();
        }
    }
}

