/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.tablesetup;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.tables.PhysicalTable;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.gui.tablelayout.TableImageSelector;
import waitermate.guikit.components.CustomCheckButton;
import waitermate.guikit.dialogs.Dialogs;

public class EditPhysicalTablePanel
extends JPanel {
    private static final int PAD = 8;
    private JLabel nameLabel;
    private JLabel displayNameLabel;
    private JLabel tableOrderableLabel;
    private CustomCheckButton tableOrderableCheck;
    private JButton nameButton;
    private JButton changeTableIconButton;
    private InnerActionListener listener;
    private String tableName;
    private String tableImagePath;
    private boolean isOrderable;
    private ImageIcon tableIcon;

    public EditPhysicalTablePanel(PhysicalTable table) {
        this.tableName = table.getName();
        this.tableImagePath = table.getTableImagePath();
        this.isOrderable = table.isCanOrderTo();
        this.tableIcon = table.getTableImage();
        this.setupComponents();
        this.changeTableIconButton.setEnabled(table.getLogicalTable().getPhysicalTables().size() == 1);
    }

    private void setupComponents() {
        this.listener = new InnerActionListener();
        this.setLayout(new BoxLayout(this, 1));
        this.nameLabel = new JLabel("Name: ");
        this.nameLabel.setFont(OrderMateTheme.getLargeFont());
        this.displayNameLabel = new JLabel(this.tableName);
        this.displayNameLabel.setFont(OrderMateTheme.getLargeFont());
        this.displayNameLabel.setHorizontalAlignment(0);
        this.displayNameLabel.setVerticalAlignment(0);
        JPanel namePanel = new JPanel(new BorderLayout());
        this.nameButton = new JButton(IconLoader.get((String)"/waitermate/guikit/images/keyboard.png"));
        this.nameButton.addActionListener(this.listener);
        namePanel.add((Component)this.nameButton, "East");
        namePanel.add((Component)this.displayNameLabel, "Center");
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 0));
        holder.add(this.nameLabel);
        holder.add(namePanel);
        this.add(holder);
        this.add(Box.createVerticalStrut(8));
        holder = new JPanel();
        holder.setLayout(new BorderLayout());
        this.tableOrderableLabel = new JLabel("Can Order to Table?");
        this.tableOrderableLabel.setFont(OrderMateTheme.getLargeFont());
        this.tableOrderableCheck = new CustomCheckButton();
        this.tableOrderableCheck.setPreferredSize(this.nameButton.getPreferredSize());
        holder.add((Component)this.tableOrderableLabel, "Center");
        holder.add((Component)this.tableOrderableCheck, "East");
        this.tableOrderableCheck.setName("canOrderTo");
        this.tableOrderableCheck.setSelected(this.isOrderable);
        this.add(holder);
        this.add(Box.createVerticalStrut(8));
        this.changeTableIconButton = new JButton();
        this.setTableIconToButton(this.tableIcon);
        this.changeTableIconButton.setPreferredSize(this.nameButton.getPreferredSize());
        this.changeTableIconButton.addActionListener(this.listener);
        this.changeTableIconButton.setName("changeTableIcon");
        holder = new JPanel(new BorderLayout());
        JLabel changeLabel = new JLabel("Change Table Icon");
        changeLabel.setFont(OrderMateTheme.getLargeFont());
        holder.add((Component)changeLabel, "Center");
        holder.add((Component)this.changeTableIconButton, "East");
        this.add(holder);
        this.add(Box.createVerticalStrut(8));
    }

    private void setTableIconToButton(ImageIcon toSet) {
        BufferedImage image = new BufferedImage(this.nameButton.getIcon().getIconWidth(), this.nameButton.getIcon().getIconHeight(), 6);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        double scale = (double)image.getWidth() / (double)toSet.getIconWidth();
        double scale2 = (double)image.getHeight() / (double)toSet.getIconHeight();
        if (scale2 < scale) {
            scale = scale2;
        }
        graphics.scale(scale, scale);
        graphics.drawImage(toSet.getImage(), 0, 0, null);
        this.changeTableIconButton.setIcon(new ImageIcon(image));
        graphics.dispose();
    }

    @Override
    public String getName() {
        return this.displayNameLabel.getText();
    }

    public boolean isCanOrderTo() {
        return this.tableOrderableCheck.isSelected();
    }

    public String getTableImagePath() {
        return this.tableImagePath;
    }

    class InnerActionListener
    implements ActionListener {
        InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == EditPhysicalTablePanel.this.nameButton) {
                String text = Dialogs.getString((String)"Enter table name: ", (String)EditPhysicalTablePanel.this.displayNameLabel.getText(), (boolean)true, (String)"Enter section name ");
                if (text != "\u0000") {
                    EditPhysicalTablePanel.this.displayNameLabel.setText(text);
                }
            } else if (src == EditPhysicalTablePanel.this.changeTableIconButton) {
                TableImageSelector selector = new TableImageSelector();
                selector.setShowIsCanOrderToTable(false);
                if (selector.start() != null) {
                    EditPhysicalTablePanel.this.tableImagePath = selector.getSelectedImagePath();
                    EditPhysicalTablePanel.this.tableIcon = (ImageIcon)selector.getSelectedImage();
                    EditPhysicalTablePanel.this.setTableIconToButton(EditPhysicalTablePanel.this.tableIcon);
                    EditPhysicalTablePanel.this.changeTableIconButton.invalidate();
                }
            }
        }
    }
}

