/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.tablesetup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;

public class SelectImagePanel
extends JPanel {
    private ImageIcon selectedImage;
    private CustomScrollPane imagePane;
    private JLabel label;
    private Map<ImageIcon, String> labelsForImages = new HashMap<ImageIcon, String>();

    public SelectImagePanel(List<ImageIcon> images, List<String> imageLabels) {
        super(new BorderLayout());
        for (int i = 0; i < images.size(); ++i) {
            this.labelsForImages.put(images.get(i), imageLabels.get(i));
        }
        ScrollPaneModel model = new ScrollPaneModel(3, 3);
        model.setImageIcons(images);
        this.label = new JLabel(" ");
        this.label.setHorizontalAlignment(0);
        Color labelColor = new Color(106, 106, 122);
        this.label.setForeground(labelColor);
        this.label.setBorder(BorderFactory.createLineBorder(labelColor));
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.add((Component)this.label, "Center");
        this.imagePane = new CustomScrollPane((CustomScrollPaneModel)model);
        this.add((Component)this.imagePane, "Center");
        this.add((Component)labelPanel, "South");
    }

    public ImageIcon getSelectedImage() {
        return this.selectedImage;
    }

    class InnerActionListener
    implements ActionListener {
        InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src instanceof JToggleButton) {
                SelectImagePanel.this.selectedImage = (ImageIcon)((JToggleButton)src).getIcon();
                String imageLabel = (String)SelectImagePanel.this.labelsForImages.get(SelectImagePanel.this.selectedImage);
                if (imageLabel == null) {
                    imageLabel = " ";
                }
                SelectImagePanel.this.label.setText(imageLabel);
                SelectImagePanel.this.repaint();
            }
        }
    }

    class ScrollPaneModel
    extends DefaultScrollPaneModel {
        ScrollPaneModel(int cols, int rows) {
            super(cols, rows);
        }

        public void setImageIcons(List<ImageIcon> imageIcons) {
            ButtonGroup group = new ButtonGroup();
            ArrayList<JToggleButton> buttons = new ArrayList<JToggleButton>();
            for (ImageIcon icon : imageIcons) {
                JToggleButton button = new JToggleButton(icon);
                button.addActionListener(new InnerActionListener());
                buttons.add(button);
                group.add(button);
            }
            this.setItems(buttons);
        }
    }
}

